/*
 * Decompiled with CFR 0.152.
 */
package net.somta.juggle.core.dispatcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.somta.juggle.core.a;
import net.somta.juggle.core.b;
import net.somta.juggle.core.dispatcher.IDispatcher;
import net.somta.juggle.core.enums.CoreErrorEnum;
import net.somta.juggle.core.enums.ElementTypeEnum;
import net.somta.juggle.core.enums.FlowStatusEnum;
import net.somta.juggle.core.enums.VariablePrefixEnum;
import net.somta.juggle.core.executor.data.IDataSource;
import net.somta.juggle.core.model.Flow;
import net.somta.juggle.core.model.FlowElement;
import net.somta.juggle.core.model.FlowResult;
import net.somta.juggle.core.model.InputParameter;
import net.somta.juggle.core.model.Variable;
import net.somta.juggle.core.result.IFlowResultManager;
import net.somta.juggle.core.variable.AbstractVariableManager;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractDispatcher
implements IDispatcher {
    protected b o;
    private ObjectMapper p = new ObjectMapper();

    public AbstractDispatcher(b workRunner) {
        this.o = workRunner;
        this.p.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public FlowResult doDispatcher(Flow flow, Map<String, Object> flowData, IFlowResultManager flowResultManager, IDataSource dataSourceManager) {
        a flowRuntimeContext = this.a(flow);
        flowRuntimeContext.setFlowResultManager(flowResultManager);
        flowRuntimeContext.setDataSourceManager(dataSourceManager);
        try {
            this.a(flowRuntimeContext.getVariableManager(), flow.getInputParams(), flowData);
        }
        catch (net.somta.juggle.core.exception.a e2) {
            e2.printStackTrace();
        }
        return this.a(flowRuntimeContext);
    }

    private void a(AbstractVariableManager variableManager, List<InputParameter> inputParams, Map<String, Object> flowData) throws net.somta.juggle.core.exception.a {
        if (MapUtils.isNotEmpty(flowData)) {
            for (InputParameter inputParam : inputParams) {
                String inputParameterVariableKey = VariablePrefixEnum.INPUT_VARIABLE_PREFIX.getCode() + inputParam.getKey();
                Object realValue = variableManager.getRealDataType(inputParameterVariableKey, flowData.get(inputParam.getKey()));
                variableManager.setVariableValue(inputParameterVariableKey, realValue);
            }
        }
    }

    private a a(Flow flow) {
        Map<String, Variable> variableSchemaMap = flow.getVariables().stream().collect(Collectors.toMap(Variable::getKey, account -> account));
        a flowRuntimeContext = new a(variableSchemaMap);
        flowRuntimeContext.setFlowInstanceId(flow.getFlowInstanceId());
        flowRuntimeContext.setFlowStatus(FlowStatusEnum.INIT);
        flowRuntimeContext.setFlowKey(flow.getFlowKey());
        flowRuntimeContext.setOutputParameters(flow.getOutputParams());
        Map<String, FlowElement> flowElementMap = this.a(flow.getFlowContent());
        if (MapUtils.isEmpty(flowElementMap)) {
            throw new net.somta.juggle.core.exception.a(CoreErrorEnum.FLOW_ELEMENT_IS_EMPTY_ERROR);
        }
        flowRuntimeContext.setFlowElementMap(flowElementMap);
        flowRuntimeContext.setCurrentNode(this.a(flowElementMap));
        return flowRuntimeContext;
    }

    private Map<String, FlowElement> a(String content) {
        try {
            List elementList = (List)this.p.readValue(content, (TypeReference)new TypeReference<List<FlowElement>>(){});
            Map<String, FlowElement> flowElementMap = elementList.stream().collect(Collectors.toMap(FlowElement::getKey, e2 -> e2));
            return flowElementMap;
        }
        catch (JsonProcessingException e3) {
            e3.printStackTrace();
            return Collections.EMPTY_MAP;
        }
    }

    private FlowElement a(Map<String, FlowElement> flowElementMap) {
        for (FlowElement flowElement : flowElementMap.values()) {
            if (flowElement.getElementType() != ElementTypeEnum.START) continue;
            return flowElement;
        }
        throw new net.somta.juggle.core.exception.a(CoreErrorEnum.FLOW_NOT_EXIST_START_NODE_ERROR);
    }

    protected abstract FlowResult a(a var1);
}

