/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Iterator;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.util.NamespaceIterator;

public class InscopeNamespaceResolver
implements NamespaceResolver {
    private NodeInfo node;

    public InscopeNamespaceResolver(NodeInfo node) {
        NodeInfo parent;
        int kind = node.getNodeKind();
        this.node = kind == 1 || kind == 9 ? node : ((parent = node.getParent()) == null ? node : parent);
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.isEmpty() && !useDefault) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(this.node);
        while (iter.hasNext()) {
            NamespaceBinding nb = iter.next();
            if (!nb.getPrefix().equals(prefix)) continue;
            return nb.getURI();
        }
        return prefix.isEmpty() ? "" : null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return new Iterator<String>(){
            int phase = 0;
            Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(InscopeNamespaceResolver.access$000(InscopeNamespaceResolver.this));

            @Override
            public boolean hasNext() {
                if (this.iter.hasNext()) {
                    return true;
                }
                if (this.phase == 0) {
                    this.phase = 1;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                if (this.phase == 1) {
                    this.phase = 2;
                    return "xml";
                }
                return this.iter.next().getPrefix();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public NodeInfo getNode() {
        return this.node;
    }

    static /* synthetic */ NodeInfo access$000(InscopeNamespaceResolver x0) {
        return x0.node;
    }
}

