/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.matching;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.MatchingStrategy;

public class CaseInsensitiveMethodNameMatchingStrategy
implements MatchingStrategy {
    private static final String SETTER_PREFIX = "set";
    private final String name;
    private final String prefix;

    public CaseInsensitiveMethodNameMatchingStrategy(String name) {
        this.name = (String)Check.notEmpty((CharSequence)name, (String)"name");
        this.prefix = SETTER_PREFIX;
    }

    public CaseInsensitiveMethodNameMatchingStrategy(String name, String prefix) {
        this.name = (String)Check.notEmpty((CharSequence)name);
        this.prefix = (String)Check.notNull((Object)prefix);
    }

    @Override
    public boolean matchesByField(Field field) {
        Check.notNull((Object)field, (String)"field");
        String fieldName = field.getName();
        return this.name.equalsIgnoreCase(fieldName);
    }

    @Override
    public boolean matchesByMethod(Method method) {
        Check.notNull((Object)method, (String)"method");
        String methodName = method.getName();
        String setterName = this.prefix + this.name;
        return this.name.equalsIgnoreCase(methodName) || setterName.equalsIgnoreCase(methodName);
    }

    @Override
    public boolean matchesByType(Class<?> clazz) {
        return false;
    }
}

