/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.creation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintExceptionRunnable;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.SafeInvoke;
import net.sf.qualitytest.exception.BlueprintException;

public class IncrementValueCreationStrategy<T extends Number>
implements CreationStrategy<T> {
    private static final Map<Class<?>, Class<? extends Number>> PRIMITIVE_MAPPING = new HashMap();
    private static final long DEFAULT_OFFSET = 1L;
    private T currentValue;
    private final long offset;
    private final long maxValueOfType;

    @ArgumentsChecked
    public IncrementValueCreationStrategy(@Nonnull T initialValue) {
        this.currentValue = (Number)Check.notNull(initialValue, (String)"initialValue");
        this.offset = 1L;
        this.maxValueOfType = this.readMaxValueOfType();
    }

    @ArgumentsChecked
    public IncrementValueCreationStrategy(@Nonnull T initialValue, long offset) {
        this.currentValue = (Number)Check.notNull(initialValue, (String)"initialValue");
        this.offset = offset;
        this.maxValueOfType = this.readMaxValueOfType();
    }

    @Override
    @ArgumentsChecked
    @Throws(value={IllegalNotNullArgumentException.class})
    public T createValue(final Class<?> expectedClazz, BlueprintConfiguration config, BlueprintSession session) {
        Check.notNull(expectedClazz, (String)"expectedClazz");
        final long value = ((Number)this.currentValue).longValue() % this.maxValueOfType + this.offset;
        String action = MessageFormat.format("Creating value {0} for type {1}.", value, expectedClazz);
        this.currentValue = (Number)SafeInvoke.invoke(new BlueprintExceptionRunnable<T>(session, action){

            @Override
            public T runInternal() throws Exception {
                if (expectedClazz.isPrimitive()) {
                    Class clazz = (Class)PRIMITIVE_MAPPING.get(expectedClazz);
                    return (Number)clazz.getConstructor(String.class).newInstance(String.valueOf(value));
                }
                return (Number)expectedClazz.getConstructor(String.class).newInstance(String.valueOf(value));
            }
        }, BlueprintException.class);
        return this.currentValue;
    }

    private long readMaxValueOfType() {
        Number n = SafeInvoke.invoke(new SafeInvoke.ExceptionRunnable<Number>(){

            @Override
            public Number run() throws Exception {
                return (Number)IncrementValueCreationStrategy.this.currentValue.getClass().getField("MAX_VALUE").get(null);
            }
        }, BlueprintException.class);
        return n.longValue();
    }

    static {
        PRIMITIVE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_MAPPING.put(Double.TYPE, Double.class);
        PRIMITIVE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAPPING.put(Short.TYPE, Short.class);
    }
}

