/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalEmptyArgumentException;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitytest.blueprint.MatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.BuilderMethodMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.CaseInsensitiveMethodNameMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.InstanceOfTypeMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.SetterMethodMatchingStrategy;
import net.sf.qualitytest.blueprint.strategy.matching.TypeMatchingStrategy;

public final class Match {
    public static final MatchingStrategy BUILDER_METHODS = new BuilderMethodMatchingStrategy();
    public static final MatchingStrategy SETTER_METHODS = new SetterMethodMatchingStrategy();

    @ArgumentsChecked
    @Throws(value={IllegalNotNullArgumentException.class})
    public static MatchingStrategy instanceOf(Class<?> clazz) {
        return new InstanceOfTypeMatchingStrategy((Class)Check.notNull(clazz, (String)"clazz"));
    }

    @ArgumentsChecked
    @Throws(value={IllegalEmptyArgumentException.class})
    public static MatchingStrategy name(String name) {
        return new CaseInsensitiveMethodNameMatchingStrategy((String)Check.notEmpty((CharSequence)name, (String)"name"));
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotNullArgumentException.class})
    public static MatchingStrategy type(Class<?> clazz) {
        return new TypeMatchingStrategy((Class)Check.notNull(clazz, (String)"clazz"));
    }

    private Match() {
    }
}

