/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueMap<K, V> {
    private final Map<K, Set<V>> keyValueMap = new HashMap<K, Set<V>>();
    private final Set<V> values = new HashSet<V>();

    public void put(K key, V value) {
        this.putAll(key, Collections.singleton(value));
    }

    public void putAll(Set<K> key, V value) {
        this.putAll((K)key, Collections.singleton(value));
    }

    public void putAll(Set<K> keys, Set<V> values) {
        for (K key : keys) {
            this.putAll(key, values);
        }
    }

    public void putAll(K key, Set<V> values) {
        this.values.addAll(values);
        Set<V> existingValues = this.keyValueMap.get(key);
        if (existingValues == null) {
            existingValues = new HashSet<V>();
            this.keyValueMap.put(key, existingValues);
        }
        existingValues.addAll(values);
    }

    public Set<V> get(K key) {
        return this.keyValueMap.get(key);
    }

    public Set<V> getValues() {
        return this.values;
    }
}

