/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.EscapingClassMarker;

public class EscapingClassFilter
implements ClassVisitor {
    private final ClassVisitor escapingClassVisitor;
    private final ClassVisitor otherClassVisitor;

    public EscapingClassFilter(ClassVisitor escapingClassVisitor) {
        this(escapingClassVisitor, null);
    }

    public EscapingClassFilter(ClassVisitor escapingClassVisitor, ClassVisitor otherClassVisitor) {
        this.escapingClassVisitor = escapingClassVisitor;
        this.otherClassVisitor = otherClassVisitor;
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = EscapingClassMarker.isClassEscaping(libraryClass) ? this.escapingClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = EscapingClassMarker.isClassEscaping(programClass) ? this.escapingClassVisitor : this.otherClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }
}

