/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.KeepMarker;

public class KeptClassFilter
implements ClassVisitor {
    private final ClassVisitor acceptedVisitor;
    private final ClassVisitor rejectedVisitor;

    public KeptClassFilter(ClassVisitor acceptedVisitor) {
        this(acceptedVisitor, null);
    }

    public KeptClassFilter(ClassVisitor acceptedVisitor, ClassVisitor rejectedVisitor) {
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor delegateVisitor = this.selectVisitor(programClass);
        if (delegateVisitor != null) {
            delegateVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor delegateVisitor = this.selectVisitor(libraryClass);
        if (delegateVisitor != null) {
            delegateVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor selectVisitor(Clazz clazz) {
        return KeepMarker.isKept(clazz) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

