/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ConstantValueFactory
extends SimplifiedVisitor
implements ConstantVisitor {
    protected final ValueFactory valueFactory;
    protected Value value;

    public ConstantValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public Value constantValue(Clazz clazz, int constantIndex) {
        clazz.constantPoolEntryAccept(constantIndex, this);
        return this.value;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.value = this.valueFactory.createIntegerValue(integerConstant.getValue());
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.value = this.valueFactory.createLongValue(longConstant.getValue());
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.value = this.valueFactory.createFloatValue(floatConstant.getValue());
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.value = this.valueFactory.createDoubleValue(doubleConstant.getValue());
    }

    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        this.value = this.valueFactory.createArrayReferenceValue("" + primitiveArrayConstant.getPrimitiveType(), null, this.valueFactory.createIntegerValue(primitiveArrayConstant.getLength()));
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/String", stringConstant.javaLangStringClass, false, false);
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/invoke/MethodHandle", methodHandleConstant.javaLangInvokeMethodHandleClass, false, false);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.value = this.valueFactory.createReferenceValue(classConstant.getName(clazz), classConstant.referencedClass, false, false);
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.value = this.valueFactory.createReferenceValue("java/lang/invoke/MethodType", methodTypeConstant.javaLangInvokeMethodTypeClass, false, false);
    }
}

