/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ConfigurationLogger
implements Runnable {
    public static final boolean LOG_ONCE = true;
    private static final String LOG_TAG = "ProGuard";
    public static final String CLASS_MAP_FILENAME = "classmap.txt";
    private static final String EMPTY_LINE = "\u00a0\n";
    private static final Set<String> missingClasses = new HashSet<String>();
    private static final Map<String, Set<MethodSignature>> missingConstructors = new HashMap<String, Set<MethodSignature>>();
    private static final Set<String> constructorListingClasses = new HashSet<String>();
    private static final Map<String, Set<MethodSignature>> missingMethods = new HashMap<String, Set<MethodSignature>>();
    private static final Set<String> methodListingClasses = new HashSet<String>();
    private static final Map<String, Set<String>> missingFields = new HashMap<String, Set<String>>();
    private static final Set<String> fieldListingCLasses = new HashSet<String>();
    private static Map<String, String> classNameMap;
    private static Set<String> classesWithObfuscatedMethods;
    private static Set<String> classesWithObfuscatedFields;
    private static Method logMethod;

    public static void logForName(String callingClassName, String missingClassName) {
        ConfigurationLogger.logMissingClass(callingClassName, "Class", "forName", missingClassName);
    }

    public static void logLoadClass(String callingClassName, String missingClassName) {
        ConfigurationLogger.logMissingClass(callingClassName, "ClassLoader", "loadClass", missingClassName);
    }

    public static void logMissingClass(String callingClassName, String invokedClassName, String invokedMethodName, String missingClassName) {
        if (!missingClasses.contains(missingClassName)) {
            missingClasses.add(missingClassName);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(callingClassName) + "' is calling " + invokedClassName + "." + invokedMethodName + " to retrieve\nthe class '" + missingClassName + "', but the latter could not be found.\nIt may have been obfuscated or shrunk.\nYou should consider preserving the class with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepClassRule(missingClassName) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredConstructor(String invokingClassName, Class reflectedClass, Class[] constructorParameters) {
        ConfigurationLogger.logGetConstructor(invokingClassName, "getDeclaredConstructor", reflectedClass, constructorParameters);
    }

    public static void logGetConstructor(String invokingClassName, Class reflectedClass, Class[] constructorParameters) {
        ConfigurationLogger.logGetConstructor(invokingClassName, "getConstructor", reflectedClass, constructorParameters);
    }

    public static void logGetConstructor(String invokingClassName, String invokedMethodName, Class reflectedClass, Class[] constructorParameters) {
        MethodSignature signature = new MethodSignature("<init>", constructorParameters);
        Set<MethodSignature> constructors = missingConstructors.get(reflectedClass.getName());
        if (constructors == null) {
            constructors = new HashSet<MethodSignature>();
            missingConstructors.put(reflectedClass.getName(), constructors);
        }
        if (!constructors.contains(signature) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            constructors.add(signature);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + invokedMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve\nthe constructor with signature (" + ConfigurationLogger.originalSignature(signature) + "), but the latter could not be found.\nIt may have been obfuscated or shrunk.\nYou should consider preserving the constructor, with a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepConstructorRule(reflectedClass.getName(), signature) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredConstructors(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetConstructors(invokingClassName, reflectedClass, "getDeclaredConstructors");
    }

    public static void logGetConstructors(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetConstructors(invokingClassName, reflectedClass, "getConstructors");
    }

    private static void logGetConstructors(String invokingClassName, Class reflectedClass, String reflectedMethodName) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedMethods.contains(reflectedClass.getName()) && !constructorListingClasses.contains(reflectedClass.getName()) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            constructorListingClasses.add(reflectedClass.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + reflectedMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its constructors.\nYou might consider preserving all constructors with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllConstructorsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredMethod(String invokingClassName, Class reflectedClass, String reflectedMethodName, Class[] methodParameters) {
        ConfigurationLogger.logGetMethod(invokingClassName, "getDeclaredMethod", reflectedClass, reflectedMethodName, methodParameters);
    }

    public static void logGetMethod(String invokingClassName, Class reflectedClass, String reflectedMethodName, Class[] methodParameters) {
        ConfigurationLogger.logGetMethod(invokingClassName, "getMethod", reflectedClass, reflectedMethodName, methodParameters);
    }

    private static void logGetMethod(String invokingClassName, String invokedReflectionMethodName, Class reflectedClass, String reflectedMethodName, Class[] methodParameters) {
        MethodSignature signature;
        Set<MethodSignature> methods = missingMethods.get(reflectedClass.getName());
        if (methods == null) {
            methods = new HashSet<MethodSignature>();
            missingMethods.put(reflectedClass.getName(), methods);
        }
        if (!methods.contains(signature = new MethodSignature(reflectedMethodName, methodParameters)) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            methods.add(signature);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + invokedReflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve the method\n" + reflectedMethodName + "(" + ConfigurationLogger.originalSignature(signature) + "),\nbut the latter could not be found. It may have been obfuscated or shrunk.\nYou should consider preserving the method with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepMethodRule(reflectedClass.getName(), reflectedMethodName, signature) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredMethods(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetMethods(invokingClassName, "getDeclaredMethods", reflectedClass);
    }

    public static void logGetMethods(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetMethods(invokingClassName, "getMethods", reflectedClass);
    }

    private static void logGetMethods(String invokingClassName, String invokedReflectionMethodName, Class reflectedClass) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedMethods.contains(reflectedClass.getName()) && !methodListingClasses.contains(reflectedClass.getName()) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            methodListingClasses.add(reflectedClass.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + invokedReflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its methods.\nYou might consider preserving all methods with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllMethodsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetField(String invokingClassName, Class reflectedClass, String reflectedFieldName) {
        ConfigurationLogger.logGetField(invokingClassName, "getField", reflectedClass, reflectedFieldName);
    }

    public static void logGetDeclaredField(String invokingClassName, Class reflectedClass, String reflectedFieldName) {
        ConfigurationLogger.logGetField(invokingClassName, "getDeclaredField", reflectedClass, reflectedFieldName);
    }

    private static void logGetField(String invokingClassName, String invokedReflectionMethodName, Class reflectedClass, String reflectedFieldName) {
        Set<String> fields = missingFields.get(reflectedClass.getName());
        if (fields == null) {
            fields = new HashSet<String>();
            missingFields.put(reflectedClass.getName(), fields);
        }
        if (!fields.contains(reflectedFieldName) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            fields.add(reflectedFieldName);
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + invokedReflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve the field '" + reflectedFieldName + "',\nbut the latter could not be found. It may have been obfuscated or shrunk.\nYou should consider preserving the field with its original name,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepFieldRule(reflectedClass.getName(), reflectedFieldName) + "\n" + EMPTY_LINE);
        }
    }

    public static void logGetDeclaredFields(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetFields(invokingClassName, "getDeclaredFields", reflectedClass);
    }

    public static void logGetFields(String invokingClassName, Class reflectedClass) {
        ConfigurationLogger.logGetFields(invokingClassName, "getFields", reflectedClass);
    }

    private static void logGetFields(String invokingClassName, String invokedReflectionMethodName, Class reflectedClass) {
        ConfigurationLogger.initializeMappings();
        if (classesWithObfuscatedFields.contains(reflectedClass.getName()) && !fieldListingCLasses.contains(reflectedClass.getName()) && !ConfigurationLogger.isLibraryClass(reflectedClass)) {
            fieldListingCLasses.add(reflectedClass.getName());
            ConfigurationLogger.log("The class '" + ConfigurationLogger.originalClassName(invokingClassName) + "' is calling Class." + invokedReflectionMethodName + "\non class '" + ConfigurationLogger.originalClassName(reflectedClass) + "' to retrieve its fields.\nYou might consider preserving all fields with their original names,\nwith a setting like:\n" + EMPTY_LINE + ConfigurationLogger.keepAllFieldsRule(reflectedClass) + "\n" + EMPTY_LINE);
        }
    }

    public void run() {
        ConfigurationLogger.printConfiguration();
    }

    private static void printConfiguration() {
        ConfigurationLogger.log("The following settings may help solving issues related to\nmissing classes, methods and/or fields:\n");
        for (String clazz : missingClasses) {
            ConfigurationLogger.log(ConfigurationLogger.keepClassRule(clazz) + "\n");
        }
        for (String clazz : missingConstructors.keySet()) {
            for (MethodSignature constructor : missingConstructors.get(clazz)) {
                ConfigurationLogger.log(ConfigurationLogger.keepConstructorRule(clazz, constructor) + "\n");
            }
        }
        for (String clazz : missingMethods.keySet()) {
            for (MethodSignature method : missingMethods.get(clazz)) {
                ConfigurationLogger.log(ConfigurationLogger.keepMethodRule(clazz, method.name, method) + "\n");
            }
        }
        for (String clazz : missingFields.keySet()) {
            for (String field : missingFields.get(clazz)) {
                ConfigurationLogger.log(ConfigurationLogger.keepFieldRule(clazz, field) + "\n");
            }
        }
    }

    private static String keepClassRule(String className) {
        return "-keep class " + className;
    }

    private static String keepConstructorRule(String className, MethodSignature constructorParameters) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    public <init>(" + ConfigurationLogger.originalSignature(constructorParameters) + ");\n}";
    }

    private static String keepMethodRule(String className, String methodName, MethodSignature constructorParameters) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    *** " + methodName + "(" + ConfigurationLogger.originalSignature(constructorParameters) + ");\n}";
    }

    private static String keepFieldRule(String className, String fieldName) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    *** " + fieldName + ";\n}";
    }

    private static String keepAllConstructorsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <init>(...);\n}";
    }

    private static String keepAllMethodsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <methods>;\n}";
    }

    private static String keepAllFieldsRule(Class className) {
        return "-keepclassmembers class " + ConfigurationLogger.originalClassName(className) + " {\n    <fields>;\n}";
    }

    private static String originalClassName(Class className) {
        return ConfigurationLogger.originalClassName(className.getName());
    }

    private static String originalClassName(String className) {
        ConfigurationLogger.initializeMappings();
        String originalClassName = classNameMap.get(className);
        return originalClassName != null ? originalClassName : className;
    }

    private static boolean isLibraryClass(Class clazz) {
        return clazz.getClassLoader() == String.class.getClassLoader();
    }

    private static void log(String message) {
        if (logMethod != null) {
            try {
                logMethod.invoke(null, LOG_TAG, message);
            }
            catch (Exception e) {
                System.err.println(message);
            }
        } else {
            System.err.println(message);
        }
    }

    private static void initializeMappings() {
        if (classNameMap == null) {
            classNameMap = new HashMap<String, String>();
            classesWithObfuscatedMethods = new HashSet<String>();
            classesWithObfuscatedFields = new HashSet<String>();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(ConfigurationLogger.class.getClassLoader().getResourceAsStream(CLASS_MAP_FILENAME)));
                while ((line = reader.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line, ",");
                    String originalClassName = tokenizer.nextToken();
                    String obfuscatedClassName = tokenizer.nextToken();
                    boolean hasObfuscatedMethods = tokenizer.nextToken().equals("1");
                    boolean hasObfuscatedFields = tokenizer.nextToken().equals("1");
                    classNameMap.put(obfuscatedClassName, originalClassName);
                    if (hasObfuscatedMethods) {
                        classesWithObfuscatedMethods.add(obfuscatedClassName);
                    }
                    if (!hasObfuscatedFields) continue;
                    classesWithObfuscatedFields.add(obfuscatedClassName);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String originalSignature(MethodSignature signature) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String clazz : signature.parameters) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(ConfigurationLogger.originalClassName(clazz));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            Class<?> logClass = Class.forName("android.util.Log");
            logMethod = logClass.getMethod("w", String.class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class MethodSignature {
        private String name;
        private String[] parameters;

        public MethodSignature(String name, Class[] parameters) {
            this.name = name;
            this.parameters = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameters[i] = parameters[i].getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return Arrays.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }
    }
}

