/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.analytics.Analytics;
import net.openhft.chronicle.analytics.internal.AnalyticsConfiguration;
import net.openhft.chronicle.analytics.internal.FilesUtil;
import net.openhft.chronicle.analytics.internal.HttpUtil;
import org.jetbrains.annotations.NotNull;

abstract class AbstractGoogleAnalytics
implements Analytics {
    private final AnalyticsConfiguration configuration;
    private final String clientId;
    private final AtomicLong lastSendAttemptNs = new AtomicLong();
    private final AtomicInteger sentMessages = new AtomicInteger();
    final boolean muted;

    AbstractGoogleAnalytics(@NotNull AnalyticsConfiguration configuration) {
        this.configuration = configuration;
        this.clientId = FilesUtil.acquireClientId(configuration.clientIdFileName(), configuration.debugLogger());
        this.muted = FilesUtil.isSameAsLastUsedFileTimeStampSecond(LocalTime.now().toSecondOfDay());
    }

    @Override
    public void sendEvent(@NotNull String name, @NotNull Map<String, String> additionalEventParameters) {
        if (this.attemptToSend()) {
            if (additionalEventParameters.isEmpty()) {
                this.httpSend(name, this.configuration.eventParameters());
            } else {
                LinkedHashMap<String, String> mergedEventParameters = new LinkedHashMap<String, String>(this.configuration.eventParameters());
                mergedEventParameters.putAll(additionalEventParameters);
                this.httpSend(name, mergedEventParameters);
            }
        }
    }

    abstract void httpSend(@NotNull String var1, @NotNull Map<String, String> var2);

    boolean attemptToSend() {
        if (this.muted) {
            return false;
        }
        if (this.configuration.duration() > 0L) {
            long nextThresholdNs = this.lastSendAttemptNs.get() + this.configuration.timeUnit().toNanos(this.configuration.duration());
            if (System.nanoTime() > nextThresholdNs || nextThresholdNs == 0L) {
                this.lastSendAttemptNs.set(System.nanoTime());
                this.sentMessages.set(1);
            } else if (this.sentMessages.getAndIncrement() >= this.configuration.messages()) {
                return false;
            }
        }
        return true;
    }

    AnalyticsConfiguration configuration() {
        return this.configuration;
    }

    String clientId() {
        return this.clientId;
    }

    String urlEncode(String s) {
        return HttpUtil.urlEncode(s, this.configuration().errorLogger());
    }
}

