/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.hasor.core.InjectSettings;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.ValueModel;
import net.hasor.dataway.daos.TestPathQuery;
import net.hasor.utils.StringUtils;

@Singleton
public class CheckService {
    @InjectSettings(value="${HASOR_DATAQL_DATAWAY_API_URL}")
    private String apiUrl;
    @Inject
    @Named(value="net.hasor.dataway.config.DatawayModule")
    private DataQL dataQL;

    public void checkApi(final String apiPath) throws IOException {
        if (StringUtils.isBlank((String)this.apiUrl)) {
            throw new IllegalArgumentException("The API path is empty.");
        }
        if (!apiPath.startsWith(this.apiUrl)) {
            throw new IllegalArgumentException("The API prefix must be " + this.apiUrl);
        }
        if (!apiPath.matches("[\\$\\(\\)\\*\\+\\-\\.!',/:;=@_~0-9a-zA-Z]+")) {
            throw new IllegalArgumentException("Allowed characters\uff1a !  $  '  (  )  *  +  ,  -  .  /  :  ;  =  @  _  ~  0-9  a-z  A-Z");
        }
        QueryResult queryResult = new TestPathQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiPath", apiPath);
            }
        });
        if (((ValueModel)queryResult.getData()).asBoolean()) {
            throw new IllegalArgumentException("this API path has been used.");
        }
    }
}

