/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.mica.ExceptionUtils;
import org.tio.utils.queue.Reader;
import org.tio.utils.queue.Writer;

public final class FileQueue<E> {
    private static final Logger log = LoggerFactory.getLogger(FileQueue.class);
    static final Map<Path, FileQueue<?>> CACHE = new ConcurrentHashMap(16);
    private final Reader<E> reader;
    private final Writer<E> writer;

    FileQueue(Path path, long maxFileSize, long maxDataSize) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.writer = new Writer(path, maxFileSize, maxDataSize);
        this.reader = new Reader<E>(path, maxFileSize, maxDataSize, this.writer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void put(E element, Function<E, byte[]> mapper) {
        this.writer.write(element, mapper);
    }

    public void put(byte[] data) {
        this.writer.write(data);
    }

    public E take(Function<byte[], E> mapper) throws InterruptedException {
        return this.reader.take(mapper);
    }

    public E poll(Function<byte[], E> mapper) {
        return this.reader.poll(mapper);
    }

    public void close() throws IOException {
        this.writer.close();
        this.reader.close();
    }

    public static final class Builder {
        private long maxFileSize = 0x6400000L;
        private long maxDataSize = 65536L;
        private Path path;

        public Builder path(String path) {
            this.path = Paths.get(path, new String[0]);
            return this;
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        public Builder maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public Builder maxDataSize(long maxDataSize) {
            this.maxDataSize = maxDataSize;
            return this;
        }

        public <E> FileQueue<E> build() {
            FileQueue queue = CollUtil.computeIfAbsent(CACHE, this.path, key -> {
                try {
                    return new FileQueue(this.path, this.maxFileSize, this.maxDataSize);
                }
                catch (IOException e) {
                    throw ExceptionUtils.unchecked(e);
                }
            });
            if (CACHE.size() == 1) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> CACHE.forEach((k, v) -> {
                    try {
                        v.close();
                        log.debug("\u961f\u5217\u505c\u6b62\uff0c\u6e05\u7406\u8d44\u6e90:{}", k);
                    }
                    catch (Exception e) {
                        log.error("\u7a0b\u5e8f\u9000\u51fa\u5173\u95ed\u6587\u4ef6\u5f02\u5e38, path:{}", k, (Object)e);
                    }
                })));
            }
            return queue;
        }
    }
}

