/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.mica;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;
import org.tio.utils.hutool.StrUtil;

public class HexUtils {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final byte[] DIGITS_LOWER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] DIGITS_UPPER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int OFFSET_BASIS = -2128831035;
    private static final int PRIME = 16777619;

    public static int hashFNV1(byte[] src) {
        return HexUtils.hashFNV1(src, 0, src.length);
    }

    public static int hashFNV1(byte[] src, int start, int len) {
        int hash = -2128831035;
        int end = start + len;
        for (int i = start; i < end; ++i) {
            hash = (hash ^ src[i]) * 16777619;
        }
        return hash;
    }

    public static byte[] encode(byte[] data) {
        return HexUtils.encode(data, true);
    }

    public static byte[] encode(byte[] data, boolean toLowerCase) {
        return HexUtils.encode(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encode(byte data) {
        byte[] out = new byte[]{DIGITS_LOWER[(0xF0 & data) >>> 4], DIGITS_LOWER[0xF & data]};
        return new String(out);
    }

    private static byte[] encode(byte[] data, byte[] digits) {
        int len = data.length;
        byte[] out = new byte[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = digits[(0xF0 & data[i]) >>> 4];
            out[j++] = digits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeToString(byte[] data, boolean toLowerCase) {
        return new String(HexUtils.encode(data, toLowerCase), StandardCharsets.US_ASCII);
    }

    public static String encodeToString(byte[] data) {
        return HexUtils.encodeToString(data, true);
    }

    @Nullable
    public static String encodeToString(@Nullable String data) {
        return HexUtils.encodeToString(data, DEFAULT_CHARSET);
    }

    @Nullable
    public static String encodeToString(@Nullable String data, Charset charset) {
        if (StrUtil.isBlank(data)) {
            return null;
        }
        return HexUtils.encodeToString(data.getBytes(charset));
    }

    public static byte[] decode(String data) {
        if (StrUtil.isBlank(data)) {
            return null;
        }
        return HexUtils.decode(data.getBytes(StandardCharsets.US_ASCII));
    }

    public static String decodeToString(byte[] data) {
        return HexUtils.decodeToString(data, DEFAULT_CHARSET);
    }

    public static String decodeToString(byte[] data, Charset charset) {
        byte[] decodeBytes = HexUtils.decode(data);
        return new String(decodeBytes, charset);
    }

    public static String decodeToString(String data) {
        if (StrUtil.isBlank(data)) {
            return null;
        }
        return HexUtils.decodeToString(data, DEFAULT_CHARSET);
    }

    public static String decodeToString(String data, Charset charset) {
        if (StrUtil.isBlank(data)) {
            return null;
        }
        return HexUtils.decodeToString(data.getBytes(StandardCharsets.US_ASCII), charset);
    }

    public static byte[] decode(byte[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + len);
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(data[j], j) << 4;
            f |= HexUtils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(byte b, int index) {
        int digit = Character.digit(b, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal byte " + b + " at index " + index);
        }
        return digit;
    }
}

