/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Type;
import java.util.List;
import org.tio.utils.json.JsonAdapter;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.core.json.JsonFactoryBuilder;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;

public class Jackson3JsonAdapter
implements JsonAdapter {
    public static final String CLAZZ_NAME = "tools.jackson.databind.json.JsonMapper";
    private final JsonMapper jsonMapper;

    public Jackson3JsonAdapter() {
        this(new JsonMapper());
    }

    public Jackson3JsonAdapter(JsonFactoryBuilder builder) {
        this(builder.build());
    }

    public Jackson3JsonAdapter(JsonFactory factory) {
        this(JsonMapper.builder((JsonFactory)factory));
    }

    public Jackson3JsonAdapter(JsonMapper.Builder builder) {
        this.jsonMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)builder.findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).changeDefaultPropertyInclusion(handler -> handler.withValueInclusion(JsonInclude.Include.NON_ABSENT))).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
    }

    public Jackson3JsonAdapter(JsonMapper jsonMapper) {
        this(jsonMapper.rebuild());
    }

    @Override
    public String toJsonString(Object object) {
        return this.jsonMapper.writeValueAsString(object);
    }

    @Override
    public byte[] toJsonBytes(Object object) {
        return this.jsonMapper.writeValueAsBytes(object);
    }

    @Override
    public <T> T readValue(String json, Class<T> clazz) {
        return (T)this.jsonMapper.readValue(json, clazz);
    }

    @Override
    public <T> T readValue(String json, Type type) {
        return (T)this.jsonMapper.readValue(json, this.getJavaType(type));
    }

    @Override
    public <T> T readValue(byte[] json, Class<T> clazz) {
        return (T)this.jsonMapper.readValue(json, clazz);
    }

    @Override
    public <T> T readValue(byte[] json, Type type) {
        return (T)this.jsonMapper.readValue(json, this.getJavaType(type));
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) {
        JavaType javaType = this.jsonMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)this.jsonMapper.readValue(json, javaType);
    }

    @Override
    public <T> List<T> readList(byte[] json, Class<T> clazz) {
        JavaType javaType = this.jsonMapper.getTypeFactory().constructCollectionType(List.class, clazz);
        return (List)this.jsonMapper.readValue(json, javaType);
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)this.jsonMapper.convertValue(fromValue, toValueType);
    }

    @Override
    public <T> T convertValue(Object fromValue, Type toValueType) {
        return (T)this.jsonMapper.convertValue(fromValue, this.getJavaType(toValueType));
    }

    private JavaType getJavaType(Type type) {
        return this.jsonMapper.getTypeFactory().constructType(type);
    }
}

