/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tio.utils.cache.CacheObj;
import org.tio.utils.cache.ReentrantCache;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.SystemTimer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskService;

public class TimedCache<K extends Serializable, V extends Serializable>
extends ReentrantCache<K, V>
implements Closeable {
    private static final long serialVersionUID = 1L;
    private final transient TimerTaskService timerTaskService = new DefaultTimerTaskService();
    private transient TimerTask timerTask;

    public TimedCache(long ttl) {
        this(ttl, new HashMap());
    }

    public TimedCache(long ttl, Map<K, CacheObj<K, V>> map) {
        this(ttl, ttl, map);
    }

    public TimedCache(long ttl, long cleanupMs) {
        this(ttl, cleanupMs, new HashMap());
    }

    public TimedCache(long ttl, long cleanupMs, Map<K, CacheObj<K, V>> map) {
        super(map, 0, ttl);
        this.timerTaskService.start();
        this.schedulePrune(cleanupMs);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }

    protected void schedulePrune(long delay) {
        this.timerTask = this.timerTaskService.addTask(timer -> new TimerTask(delay, (SystemTimer)timer){
            final /* synthetic */ SystemTimer val$timer;
            {
                this.val$timer = systemTimer;
                super(delayMs);
            }

            @Override
            public void run() {
                this.val$timer.add(this);
                TimedCache.this.pruneCache();
            }
        });
    }

    public void cancelPruneSchedule() {
        if (null != this.timerTask) {
            this.timerTask.cancel();
        }
    }

    @Override
    public void close() throws IOException {
        this.cancelPruneSchedule();
        this.timerTaskService.stop();
    }
}

