/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.tio.utils.hutool.CollUtil;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final Map<String, DefaultThreadFactory> mapOfNameAndThreadFactory = new HashMap<String, DefaultThreadFactory>();
    private static final Map<String, AtomicInteger> mapOfNameAndAtomicInteger = new HashMap<String, AtomicInteger>();
    private String threadPoolName = null;
    private int priority = 5;

    private DefaultThreadFactory() {
    }

    public static DefaultThreadFactory getInstance(String threadName) {
        return DefaultThreadFactory.getInstance(threadName, 5);
    }

    public static DefaultThreadFactory getInstance(String threadName, Integer priority) {
        return CollUtil.computeIfAbsent(mapOfNameAndThreadFactory, threadName, key -> {
            DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory();
            if (priority != null) {
                defaultThreadFactory.priority = priority;
            }
            defaultThreadFactory.setThreadName((String)key);
            mapOfNameAndAtomicInteger.put((String)key, new AtomicInteger());
            return defaultThreadFactory;
        });
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName(this.getThreadPoolName() + '-' + mapOfNameAndAtomicInteger.get(this.getThreadPoolName()).incrementAndGet());
        thread.setPriority(this.priority);
        return thread;
    }

    public void setThreadName(String threadName) {
        this.threadPoolName = threadName;
    }
}

