/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mapped
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Mapped.class);
    protected static final int DATA_FILENAME_MAX_LENGTH = 19;
    protected static Consumer<MappedByteBuffer> buffCleaner;
    protected boolean newed;
    private RandomAccessFile rw;
    protected FileChannel channel;
    protected MappedByteBuffer buffer;

    protected Mapped(Path path, long pos, long size) throws IOException {
        this.newed = !Files.exists(path, new LinkOption[0]);
        this.rw = new RandomAccessFile(path.toFile(), "rw");
        this.channel = this.rw.getChannel();
        this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, pos, size);
    }

    @Override
    public void close() throws IOException {
        buffCleaner.accept(this.buffer);
        this.force();
        this.channel.close();
        this.rw.close();
        this.buffer = null;
        this.channel = null;
        this.rw = null;
    }

    public void force() throws IOException {
        this.channel.force(true);
    }

    public static Path pathname(Path path, long name, String extension) {
        return path.resolve(String.format("%019d", name) + extension);
    }

    static {
        try {
            Class<?> unsafeCls = Class.forName("sun.misc.Unsafe");
            Field field = unsafeCls.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method method = unsafeCls.getMethod("invokeCleaner", ByteBuffer.class);
            buffCleaner = buffer -> {
                try {
                    method.invoke(unsafe, buffer);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            };
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        if (buffCleaner == null) {
            ByteBuffer direct = ByteBuffer.allocateDirect(0);
            try {
                Field cleanerField = direct.getClass().getDeclaredField("cleaner");
                cleanerField.setAccessible(true);
                Object cleaner = cleanerField.get(direct);
                Method cleanMethod = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
                cleanMethod.invoke(cleaner, new Object[0]);
                buffCleaner = buffer -> {
                    try {
                        Object bufferCleaner = cleanerField.get(buffer);
                        cleanMethod.invoke(bufferCleaner, new Object[0]);
                    }
                    catch (Exception ee) {
                        log.error(ee.getMessage(), (Throwable)ee);
                    }
                };
            }
            catch (Exception e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (buffCleaner == null) {
            log.warn("\u6ca1\u6709\u627e\u5230 DirectByteBuffer cleaner");
            buffCleaner = Buffer::clear;
        }
    }
}

