/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.tio.utils.cache.CacheObj;
import org.tio.utils.cache.StampedCache;

public class LFUCache<K extends Serializable, V extends Serializable>
extends StampedCache<K, V> {
    private static final long serialVersionUID = 1L;

    public LFUCache(int capacity) {
        this(capacity, 0L);
    }

    public LFUCache(int capacity, long timeout) {
        super(new HashMap(capacity + 1, 1.0f), capacity, timeout);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj comin = null;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (co.isExpired()) {
                values.remove();
                this.onRemove(co.key, co.obj);
                ++count;
                continue;
            }
            if (comin != null && co.accessCount.get() >= comin.accessCount.get()) continue;
            comin = co;
        }
        if (this.isFull() && comin != null) {
            long minAccessCount = comin.accessCount.get();
            values = this.cacheObjIter();
            while (values.hasNext()) {
                CacheObj co1 = values.next();
                if (co1.accessCount.addAndGet(-minAccessCount) > 0L) continue;
                values.remove();
                this.onRemove(co1.key, co1.obj);
                ++count;
            }
        }
        return count;
    }
}

