/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.server;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.tio.core.Node;
import org.tio.core.intf.TioUuid;
import org.tio.core.uuid.SeqTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.server.HttpTioServerHandler;
import org.tio.http.server.HttpTioServerListener;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class HttpServerStarter {
    private final HttpConfig httpConfig;
    private final HttpTioServerHandler httpTioServerHandler;
    private final HttpTioServerListener httpTioServerListener;
    private final TioServerConfig tioServerConfig;
    private final TioServer tioServer;
    private final HttpRequestHandler httpRequestHandler;

    public HttpServerStarter(int port, HttpRequestHandler requestHandler) {
        this(new Node(null, port), new HttpConfig(), requestHandler, null, null);
    }

    public HttpServerStarter(String ip, int port, HttpRequestHandler requestHandler) {
        this(new Node(ip, port), new HttpConfig(), requestHandler, null, null);
    }

    public HttpServerStarter(Node serverNode, HttpRequestHandler requestHandler) {
        this(serverNode, new HttpConfig(), requestHandler, null, null);
    }

    public HttpServerStarter(Node serverNode, HttpConfig httpConfig, HttpRequestHandler requestHandler) {
        this(serverNode, httpConfig, requestHandler, null, null);
    }

    public HttpServerStarter(Node serverNode, HttpConfig httpConfig, HttpRequestHandler requestHandler, SynThreadPoolExecutor tioExecutor, ExecutorService groupExecutor) {
        if (tioExecutor == null) {
            tioExecutor = ThreadUtils.getTioExecutor();
        }
        if (groupExecutor == null) {
            groupExecutor = ThreadUtils.getGroupExecutor();
        }
        this.httpConfig = httpConfig;
        this.httpRequestHandler = Objects.requireNonNull(requestHandler);
        this.httpTioServerHandler = new HttpTioServerHandler(httpConfig, requestHandler);
        this.httpTioServerListener = new HttpTioServerListener();
        String name = httpConfig.getName();
        if (StrUtil.isBlank((CharSequence)name)) {
            name = "Tio Http Server";
        }
        this.tioServerConfig = new TioServerConfig(name, (TioServerHandler)this.httpTioServerHandler, (TioServerListener)this.httpTioServerListener, tioExecutor, groupExecutor);
        this.tioServerConfig.setHeartbeatTimeout(30000L);
        this.tioServerConfig.setShortConnection(true);
        this.tioServerConfig.setReadBufferSize(132476);
        this.tioServerConfig.setTioUuid((TioUuid)new SeqTioUuid());
        this.tioServer = new TioServer(serverNode, this.tioServerConfig);
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.httpRequestHandler;
    }

    public HttpTioServerHandler getHttpTioServerHandler() {
        return this.httpTioServerHandler;
    }

    public HttpTioServerListener getHttpTioServerListener() {
        return this.httpTioServerListener;
    }

    public void start() throws IOException {
        this.tioServer.start();
    }

    public boolean stop() {
        return this.tioServer.stop();
    }
}

