/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common.handler;

import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseStatus;
import org.tio.http.common.RequestLine;

@FunctionalInterface
public interface HttpRequestHandler {
    public HttpResponse handler(HttpRequest var1) throws Exception;

    default public HttpResponse resp404(HttpRequest request, RequestLine requestLine) {
        return this.respStatus(request, HttpResponseStatus.C404);
    }

    default public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) {
        return this.respStatus(request, HttpResponseStatus.C500);
    }

    default public HttpResponse respStatus(HttpRequest request, HttpResponseStatus status) {
        HttpResponse httpResponse = new HttpResponse(request);
        httpResponse.setStatus(status);
        return httpResponse;
    }

    default public HttpConfig getHttpConfig(HttpRequest request) {
        return request.getHttpConfig();
    }
}

