/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.tio.core.intf.TioUuid;
import org.tio.core.uuid.SnowflakeTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.server.WsTioServerHandler;
import org.tio.websocket.server.WsTioServerListener;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerStarter {
    private final HttpConfig wsServerConfig;
    private final IWsMsgHandler wsMsgHandler;
    private final WsTioServerHandler wsTioServerHandler;
    private final WsTioServerListener wsTioServerListener;
    private final TioServerConfig tioServerConfig;
    private final TioServer tioServer;

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler) throws IOException {
        this(port, wsMsgHandler, null, null);
    }

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(new HttpConfig(port), wsMsgHandler, tioExecutor, groupExecutor);
    }

    public WsServerStarter(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler) throws IOException {
        this(wsServerConfig, wsMsgHandler, null, null);
    }

    public WsServerStarter(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(wsServerConfig, wsMsgHandler, (TioUuid)new SnowflakeTioUuid(), tioExecutor, groupExecutor);
    }

    public WsServerStarter(HttpConfig wsServerConfig, IWsMsgHandler wsMsgHandler, TioUuid tioUuid, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
        this.wsTioServerHandler = new WsTioServerHandler(wsServerConfig, wsMsgHandler);
        this.wsTioServerListener = new WsTioServerListener();
        this.tioServerConfig = new TioServerConfig("Tio Websocket Server", (TioServerHandler)this.wsTioServerHandler, (TioServerListener)this.wsTioServerListener, tioExecutor, (ExecutorService)groupExecutor);
        this.tioServerConfig.setHeartbeatTimeout(0L);
        this.tioServerConfig.setTioUuid(tioUuid);
        this.tioServerConfig.setReadBufferSize(30720);
        this.tioServer = new TioServer(this.tioServerConfig);
    }

    public TioServer getTioServer() {
        return this.tioServer;
    }

    public HttpConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public IWsMsgHandler getWsMsgHandler() {
        return this.wsMsgHandler;
    }

    public WsTioServerHandler getWsTioServerHandler() {
        return this.wsTioServerHandler;
    }

    public WsTioServerListener getWsTioServerListener() {
        return this.wsTioServerListener;
    }

    public TioServerConfig getTioServerConfig() {
        return this.tioServerConfig;
    }

    public void start() throws IOException {
        this.tioServer.start(this.wsServerConfig.getBindIp(), this.wsServerConfig.getBindPort());
    }
}

