/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server.cluster.core;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.tio.client.intf.TioClientHandler;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.cluster.codec.ClusterMessageDecoder;
import org.tio.server.cluster.codec.ClusterMessageEncoder;
import org.tio.server.cluster.message.AbsClusterMessage;
import org.tio.server.cluster.message.ClusterPingMessage;
import org.tio.server.cluster.message.ClusterSyncAckMessage;

public class ClusterTcpClientHandler
implements TioClientHandler {
    private final ClusterMessageEncoder messageEncoder = ClusterMessageEncoder.INSTANCE;
    private final ClusterMessageDecoder messageDecoder;
    private final ConcurrentMap<Long, CompletableFuture<ClusterSyncAckMessage>> syncMessageMap;

    public ClusterTcpClientHandler(ClusterMessageDecoder messageDecoder, ConcurrentMap<Long, CompletableFuture<ClusterSyncAckMessage>> syncMessageMap) {
        this.messageDecoder = messageDecoder;
        this.syncMessageMap = syncMessageMap;
    }

    @Override
    public Packet heartbeatPacket(ChannelContext context) {
        return ClusterPingMessage.INSTANCE;
    }

    @Override
    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        return this.messageDecoder.decode(context, buffer, readableLength);
    }

    @Override
    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext context) {
        return this.messageEncoder.encode((AbsClusterMessage)packet);
    }

    @Override
    public void handler(Packet packet, ChannelContext context) throws Exception {
        ClusterSyncAckMessage message;
        long messageId;
        CompletableFuture future;
        if (packet instanceof ClusterSyncAckMessage && (future = (CompletableFuture)this.syncMessageMap.get(messageId = (message = (ClusterSyncAckMessage)packet).getMessageId())) != null) {
            future.complete(message);
        }
    }
}

