/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.IgnorePacket;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioHandler;
import org.tio.core.intf.TioListener;
import org.tio.core.stat.ChannelStat;
import org.tio.server.proxy.ProxyProtocolDecoder;
import org.tio.utils.buffer.ByteBufferUtil;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class DecodeRunnable
extends AbstractQueueRunnable<ByteBuffer> {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private final ChannelContext channelContext;
    private final TioConfig tioConfig;
    private final TioHandler tioHandler;
    private final TioListener tioListener;
    private final Queue<ByteBuffer> msgQueue;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newReceivedByteBuffer = null;

    public DecodeRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.tioConfig = channelContext.tioConfig;
        this.tioHandler = this.tioConfig.getTioHandler();
        this.tioListener = this.tioConfig.getTioListener();
        this.msgQueue = this.tioConfig.useQueueDecode ? new ConcurrentLinkedQueue() : null;
    }

    public void handler(Packet packet, int byteCount) {
        switch (this.tioConfig.packetHandlerMode) {
            case QUEUE: {
                this.channelContext.handlerRunnable.addMsg(packet);
                this.channelContext.handlerRunnable.execute();
                break;
            }
            default: {
                this.channelContext.handlerRunnable.handler(packet);
            }
        }
    }

    public void clearMsgQueue() {
        super.clearMsgQueue();
        this.lastByteBuffer = null;
        this.newReceivedByteBuffer = null;
    }

    public void runTask() {
        while ((this.newReceivedByteBuffer = this.msgQueue.poll()) != null) {
            this.decode();
        }
    }

    public void decode() {
        ByteBuffer byteBuffer = this.newReceivedByteBuffer;
        if (this.lastByteBuffer != null) {
            byteBuffer = ByteBufferUtil.composite((ByteBuffer)this.lastByteBuffer, (ByteBuffer)byteBuffer);
            this.lastByteBuffer = null;
        }
        boolean isServer = this.tioConfig.isServer();
        try {
            while (true) {
                int initPosition = byteBuffer.position();
                int limit = byteBuffer.limit();
                int readableLength = limit - initPosition;
                Packet packet = null;
                Integer packetNeededLength = this.channelContext.packetNeededLength;
                if (packetNeededLength != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{}, \u89e3\u7801\u6240\u9700\u957f\u5ea6:{}", (Object)this.channelContext, (Object)packetNeededLength);
                    }
                    if (readableLength >= packetNeededLength) {
                        packet = this.decodePacket(isServer, byteBuffer, limit, initPosition, readableLength);
                    }
                } else {
                    try {
                        packet = this.decodePacket(isServer, byteBuffer, limit, initPosition, readableLength);
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (packet == null) {
                    if (this.tioConfig.useQueueDecode || byteBuffer != this.newReceivedByteBuffer) {
                        byteBuffer.position(initPosition);
                        byteBuffer.limit(limit);
                        this.lastByteBuffer = byteBuffer;
                    } else {
                        this.lastByteBuffer = ByteBufferUtil.copy((ByteBuffer)byteBuffer, (int)initPosition, (int)limit);
                    }
                    ChannelStat channelStat = this.channelContext.stat;
                    ++channelStat.decodeFailCount;
                    if (log.isDebugEnabled()) {
                        log.debug("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                    }
                    if (channelStat.decodeFailCount > this.tioConfig.maxDecodeFailCount) {
                        int per;
                        if (packetNeededLength == null && log.isInfoEnabled()) {
                            log.info("{} \u672c\u6b21\u89e3\u7801\u5931\u8d25, \u5df2\u7ecf\u8fde\u7eed{}\u6b21\u89e3\u7801\u5931\u8d25\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171{}\u5b57\u8282", new Object[]{this.channelContext, channelStat.decodeFailCount, readableLength});
                        }
                        if ((per = readableLength / channelStat.decodeFailCount) < Math.min(this.channelContext.getReadBufferSize() / 2, 256)) {
                            String str = "\u8fde\u7eed\u89e3\u7801" + channelStat.decodeFailCount + "\u6b21\u90fd\u4e0d\u6210\u529f\uff0c\u53c2\u4e0e\u89e3\u7801\u7684\u6570\u636e\u957f\u5ea6\u5171" + readableLength + "\u5b57\u8282\uff0c";
                            if (packetNeededLength != null) {
                                str = str + "\u89e3\u7801\u6240\u9700\u957f\u5ea6" + packetNeededLength + "\u5b57\u8282\uff0c";
                            }
                            str = str + "\u5e76\u4e14\u5e73\u5747\u6bcf\u6b21\u63a5\u6536\u5230\u7684\u6570\u636e\u4e3a" + per + "\u5b57\u8282\uff0c\u6709\u6162\u653b\u51fb\u7684\u5acc\u7591";
                            String hexDump = ByteBufferUtil.hexDump((ByteBuffer)this.lastByteBuffer);
                            log.error("{} {}\uff0c\u62a5\u6587\u7ed3\u6784\uff1a\n{}", new Object[]{this.channelContext, str, hexDump});
                            throw new TioDecodeException(str);
                        }
                    }
                    return;
                }
                this.channelContext.setPacketNeededLength(null);
                this.channelContext.stat.latestTimeOfReceivedPacket = System.currentTimeMillis();
                this.channelContext.stat.decodeFailCount = 0;
                int packetSize = byteBuffer.position() - initPosition;
                packet.setByteCount(packetSize);
                if (this.tioConfig.statOn) {
                    this.tioConfig.groupStat.receivedPackets.increment();
                    this.channelContext.stat.receivedPackets.incrementAndGet();
                }
                if (this.tioListener != null) {
                    try {
                        this.tioListener.onAfterDecoded(this.channelContext, packet, packetSize);
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}, \u89e3\u5305\u83b7\u5f97\u4e00\u4e2apacket:{}", (Object)this.channelContext, (Object)packet.logstr());
                }
                if (!(packet instanceof IgnorePacket)) {
                    this.handler(packet, packetSize);
                }
                if (!byteBuffer.hasRemaining()) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", (Object)this.channelContext, (Object)byteBuffer.remaining());
            }
            this.lastByteBuffer = null;
            if (log.isDebugEnabled()) {
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", (Object)this.channelContext);
            }
            return;
        }
        catch (Throwable e) {
            if (this.channelContext.isLogWhenDecodeError()) {
                log.error("\u89e3\u7801\u65f6\u9047\u5230\u5f02\u5e38", e);
            }
            this.channelContext.setPacketNeededLength(null);
            Tio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage(), ChannelContext.CloseCode.DECODE_ERROR);
            return;
        }
    }

    private Packet decodePacket(boolean isServer, ByteBuffer byteBuffer, int limit, int initPosition, int readableLength) throws TioDecodeException {
        if (isServer) {
            return ProxyProtocolDecoder.decodeIfEnable(this.channelContext, byteBuffer, readableLength, (context, buffer, readableLen) -> this.tioHandler.decode(buffer, limit, initPosition, readableLen, context));
        }
        return this.tioHandler.decode(byteBuffer, limit, initPosition, readableLength, this.channelContext);
    }

    public void setNewReceivedByteBuffer(ByteBuffer newReceivedByteBuffer) {
        this.newReceivedByteBuffer = newReceivedByteBuffer;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ':' + this.channelContext.toString();
    }

    public String logstr() {
        return this.toString();
    }

    public Queue<ByteBuffer> getMsgQueue() {
        return this.msgQueue;
    }
}

