/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.codec;

import net.dreamlu.iot.mqtt.codec.DecoderResult;
import net.dreamlu.iot.mqtt.codec.MqttConnAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttConnAckVariableHeader;
import net.dreamlu.iot.mqtt.codec.MqttConnectMessage;
import net.dreamlu.iot.mqtt.codec.MqttConnectPayload;
import net.dreamlu.iot.mqtt.codec.MqttConnectVariableHeader;
import net.dreamlu.iot.mqtt.codec.MqttFixedHeader;
import net.dreamlu.iot.mqtt.codec.MqttMessage;
import net.dreamlu.iot.mqtt.codec.MqttMessageIdVariableHeader;
import net.dreamlu.iot.mqtt.codec.MqttPubAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.codec.MqttPublishVariableHeader;
import net.dreamlu.iot.mqtt.codec.MqttSubAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttSubAckPayload;
import net.dreamlu.iot.mqtt.codec.MqttSubscribeMessage;
import net.dreamlu.iot.mqtt.codec.MqttSubscribePayload;
import net.dreamlu.iot.mqtt.codec.MqttUnsubAckMessage;
import net.dreamlu.iot.mqtt.codec.MqttUnsubAckPayload;
import net.dreamlu.iot.mqtt.codec.MqttUnsubscribeMessage;
import net.dreamlu.iot.mqtt.codec.MqttUnsubscribePayload;

public final class MqttMessageFactory {
    public static MqttMessage newMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Object payload) {
        switch (mqttFixedHeader.messageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader, (MqttConnectVariableHeader)variableHeader, (MqttConnectPayload)payload);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader, (MqttConnAckVariableHeader)variableHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubscribePayload)payload);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttSubAckPayload)payload);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubAckPayload)payload);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader, (MqttUnsubscribePayload)payload);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader, (MqttPublishVariableHeader)variableHeader, (byte[])payload);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader, (MqttMessageIdVariableHeader)variableHeader);
            }
            case PUBREC: 
            case PUBREL: 
            case PUBCOMP: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
            case PINGREQ: 
            case PINGRESP: {
                return new MqttMessage(mqttFixedHeader);
            }
            case DISCONNECT: 
            case AUTH: {
                return new MqttMessage(mqttFixedHeader, variableHeader);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.messageType()));
    }

    public static MqttMessage newInvalidMessage(Throwable cause) {
        return new MqttMessage(null, null, null, DecoderResult.failure(cause));
    }

    public static MqttMessage newInvalidMessage(MqttFixedHeader mqttFixedHeader, Object variableHeader, Throwable cause) {
        return new MqttMessage(mqttFixedHeader, variableHeader, null, DecoderResult.failure(cause));
    }

    private MqttMessageFactory() {
    }
}

