/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import com.google.common.net.InetAddresses;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.devh.boot.grpc.common.security.KeyStoreUtils;
import net.devh.boot.grpc.common.util.GrpcUtils;
import net.devh.boot.grpc.server.config.ClientAuth;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.AbstractGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import org.springframework.core.io.Resource;

public class ShadedNettyGrpcServerFactory
extends AbstractGrpcServerFactory<NettyServerBuilder> {
    public ShadedNettyGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        super(properties, serverConfigurers);
    }

    @Override
    protected NettyServerBuilder newServerBuilder() {
        String address = this.getAddress();
        int port = this.getPort();
        if (address.startsWith("unix:")) {
            String path = GrpcUtils.extractDomainSocketAddressPath((String)address);
            return NettyServerBuilder.forAddress((SocketAddress)new DomainSocketAddress(path)).channelType(EpollServerDomainSocketChannel.class).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1)).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
        }
        if ("*".equals(address)) {
            return NettyServerBuilder.forPort((int)port);
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port));
    }

    @Override
    protected void configureConnectionLimits(NettyServerBuilder builder) {
        if (this.properties.getMaxConnectionIdle() != null) {
            builder.maxConnectionIdle(this.properties.getMaxConnectionIdle().toNanos(), TimeUnit.NANOSECONDS);
        }
        if (this.properties.getMaxConnectionAge() != null) {
            builder.maxConnectionAge(this.properties.getMaxConnectionAge().toNanos(), TimeUnit.NANOSECONDS);
        }
        if (this.properties.getMaxConnectionAgeGrace() != null) {
            builder.maxConnectionAgeGrace(this.properties.getMaxConnectionAgeGrace().toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    @Override
    protected void configureKeepAlive(NettyServerBuilder builder) {
        if (this.properties.isEnableKeepAlive()) {
            builder.keepAliveTime(this.properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(this.properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS);
        }
        builder.permitKeepAliveTime(this.properties.getPermitKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).permitKeepAliveWithoutCalls(this.properties.isPermitKeepAliveWithoutCalls());
    }

    @Override
    protected void configureSecurity(NettyServerBuilder builder) {
        GrpcServerProperties.Security security = this.properties.getSecurity();
        if (security.isEnabled()) {
            SslContextBuilder sslContextBuilder = ShadedNettyGrpcServerFactory.newServerSslContextBuilder(security);
            ShadedNettyGrpcServerFactory.configureAcceptedClientCertificates(security, sslContextBuilder);
            if (security.getCiphers() != null && !security.getCiphers().isEmpty()) {
                sslContextBuilder.ciphers(security.getCiphers());
            }
            if (security.getProtocols() != null && security.getProtocols().length > 0) {
                sslContextBuilder.protocols(security.getProtocols());
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc server", e);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static SslContextBuilder newServerSslContextBuilder(GrpcServerProperties.Security security) {
        try {
            Resource privateKey = security.getPrivateKey();
            Resource keyStore = security.getKeyStore();
            if (privateKey != null) {
                Resource certificateChain = Objects.requireNonNull(security.getCertificateChain(), "certificateChain");
                String privateKeyPassword = security.getPrivateKeyPassword();
                try (InputStream certificateChainStream = certificateChain.getInputStream();){
                    SslContextBuilder sslContextBuilder;
                    block16: {
                        InputStream privateKeyStream = privateKey.getInputStream();
                        try {
                            sslContextBuilder = GrpcSslContexts.forServer((InputStream)certificateChainStream, (InputStream)privateKeyStream, (String)privateKeyPassword);
                            if (privateKeyStream == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (privateKeyStream != null) {
                                try {
                                    privateKeyStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        privateKeyStream.close();
                    }
                    return sslContextBuilder;
                }
            }
            if (keyStore != null) {
                KeyManagerFactory keyManagerFactory = KeyStoreUtils.loadKeyManagerFactory((String)security.getKeyStoreFormat(), (Resource)keyStore, (String)security.getKeyStorePassword());
                return GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory));
            }
            throw new IllegalStateException("Neither privateKey nor keyStore configured");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create SSLContext (PK/Cert)", e);
        }
    }

    protected static void configureAcceptedClientCertificates(GrpcServerProperties.Security security, SslContextBuilder sslContextBuilder) {
        block11: {
            if (security.getClientAuth() != ClientAuth.NONE) {
                sslContextBuilder.clientAuth(ShadedNettyGrpcServerFactory.of(security.getClientAuth()));
                try {
                    Resource trustCertCollection = security.getTrustCertCollection();
                    Resource trustStore = security.getTrustStore();
                    if (trustCertCollection != null) {
                        try (InputStream trustCertCollectionStream = trustCertCollection.getInputStream();){
                            sslContextBuilder.trustManager(trustCertCollectionStream);
                            break block11;
                        }
                    }
                    if (trustStore != null) {
                        TrustManagerFactory trustManagerFactory = KeyStoreUtils.loadTrustManagerFactory((String)security.getTrustStoreFormat(), (Resource)trustStore, (String)security.getTrustStorePassword());
                        sslContextBuilder.trustManager(trustManagerFactory);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to create SSLContext (TrustStore)", e);
                }
            }
        }
    }

    protected static io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth of(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClientAuth: " + clientAuth);
    }
}

