/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.metrics;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Supplier;
import net.devh.boot.grpc.common.util.Constants;
import net.devh.boot.grpc.server.metrics.MetricsServerInstruments;
import net.devh.boot.grpc.server.metrics.MetricsServerMeters;

public final class MetricsServerStreamTracers {
    private static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = Stopwatch::createUnstarted;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private static final String INSTRUMENTATION_SOURCE_TAG_KEY = "instrumentation_source";
    private static final String INSTRUMENTATION_VERSION_TAG_KEY = "instrumentation_version";

    public MetricsServerStreamTracers() {
        this(STOPWATCH_SUPPLIER);
    }

    public MetricsServerStreamTracers(Supplier<Stopwatch> stopwatchSupplier) {
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
    }

    public ServerStreamTracer.Factory getMetricsServerTracerFactory(MeterRegistry registry) {
        return new MetricsServerTracerFactory(registry);
    }

    public ServerStreamTracer.Factory getMetricsServerTracerFactory(MetricsServerMeters meters) {
        return new MetricsServerTracerFactory(meters);
    }

    final class MetricsServerTracerFactory
    extends ServerStreamTracer.Factory {
        private final MetricsServerMeters metricsServerMeters;

        MetricsServerTracerFactory(MeterRegistry registry) {
            this(MetricsServerInstruments.newServerMetricsMeters(registry));
        }

        MetricsServerTracerFactory(MetricsServerMeters metricsServerMeters) {
            this.metricsServerMeters = metricsServerMeters;
        }

        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            return new ServerTracer(MetricsServerStreamTracers.this, fullMethodName, this.metricsServerMeters);
        }
    }

    private static final class ServerTracer
    extends ServerStreamTracer {
        private final MetricsServerStreamTracers tracer;
        private final String fullMethodName;
        private final MetricsServerMeters metricsServerMeters;
        private final Stopwatch stopwatch;
        private static final AtomicLongFieldUpdater<ServerTracer> outboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundWireSize");
        private static final AtomicLongFieldUpdater<ServerTracer> inboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundWireSize");
        private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
        private volatile long outboundWireSize;
        private volatile long inboundWireSize;
        private volatile int streamClosed;

        ServerTracer(MetricsServerStreamTracers tracer, String fullMethodName, MetricsServerMeters meters) {
            this.tracer = (MetricsServerStreamTracers)Preconditions.checkNotNull((Object)tracer, (Object)"tracer");
            this.fullMethodName = fullMethodName;
            this.metricsServerMeters = meters;
            this.stopwatch = tracer.stopwatchSupplier.get().start();
        }

        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            ((Counter)this.metricsServerMeters.getServerCallCounter().withTags((Iterable)Tags.of((String[])new String[]{"grpc.method", this.fullMethodName, MetricsServerStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsServerStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION}))).increment();
        }

        public void outboundWireSize(long bytes) {
            outboundWireSizeUpdater.getAndAdd(this, bytes);
        }

        public void inboundWireSize(long bytes) {
            inboundWireSizeUpdater.getAndAdd(this, bytes);
        }

        public void streamClosed(Status status) {
            if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                return;
            }
            long callLatencyNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Tags serverMetricTags = Tags.of((String[])new String[]{"grpc.method", this.fullMethodName, "grpc.status", status.getCode().toString(), MetricsServerStreamTracers.INSTRUMENTATION_SOURCE_TAG_KEY, "grpc-spring", MetricsServerStreamTracers.INSTRUMENTATION_VERSION_TAG_KEY, Constants.VERSION});
            ((Timer)this.metricsServerMeters.getServerCallDuration().withTags((Iterable)serverMetricTags)).record(callLatencyNanos, TimeUnit.NANOSECONDS);
            ((DistributionSummary)this.metricsServerMeters.getSentMessageSizeDistribution().withTags((Iterable)serverMetricTags)).record((double)this.outboundWireSize);
            ((DistributionSummary)this.metricsServerMeters.getReceivedMessageSizeDistribution().withTags((Iterable)serverMetricTags)).record((double)this.inboundWireSize);
        }
    }
}

