/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;

public class MetricsServerMeters {
    private Meter.MeterProvider<Counter> serverCallCounter;
    private Meter.MeterProvider<DistributionSummary> sentMessageSizeDistribution;
    private Meter.MeterProvider<DistributionSummary> receivedMessageSizeDistribution;
    private Meter.MeterProvider<Timer> serverCallDuration;

    private MetricsServerMeters(Builder builder) {
        this.serverCallCounter = builder.serverCallCounter;
        this.sentMessageSizeDistribution = builder.sentMessageSizeDistribution;
        this.receivedMessageSizeDistribution = builder.receivedMessageSizeDistribution;
        this.serverCallDuration = builder.serverCallDuration;
    }

    public Meter.MeterProvider<Counter> getServerCallCounter() {
        return this.serverCallCounter;
    }

    public Meter.MeterProvider<DistributionSummary> getSentMessageSizeDistribution() {
        return this.sentMessageSizeDistribution;
    }

    public Meter.MeterProvider<DistributionSummary> getReceivedMessageSizeDistribution() {
        return this.receivedMessageSizeDistribution;
    }

    public Meter.MeterProvider<Timer> getServerCallDuration() {
        return this.serverCallDuration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private Meter.MeterProvider<Counter> serverCallCounter;
        private Meter.MeterProvider<DistributionSummary> sentMessageSizeDistribution;
        private Meter.MeterProvider<DistributionSummary> receivedMessageSizeDistribution;
        private Meter.MeterProvider<Timer> serverCallDuration;

        private Builder() {
        }

        public Builder setServerCallCounter(Meter.MeterProvider<Counter> counter) {
            this.serverCallCounter = counter;
            return this;
        }

        public Builder setSentMessageSizeDistribution(Meter.MeterProvider<DistributionSummary> distribution) {
            this.sentMessageSizeDistribution = distribution;
            return this;
        }

        public Builder setReceivedMessageSizeDistribution(Meter.MeterProvider<DistributionSummary> distribution) {
            this.receivedMessageSizeDistribution = distribution;
            return this;
        }

        public Builder setServerCallDuration(Meter.MeterProvider<Timer> timer) {
            this.serverCallDuration = timer;
            return this;
        }

        public MetricsServerMeters build() {
            return new MetricsServerMeters(this);
        }
    }
}

