/*
 * Decompiled with CFR 0.152.
 */
package brave.rpc;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.rpc.RpcHandler;
import brave.rpc.RpcRequest;
import brave.rpc.RpcServerRequest;
import brave.rpc.RpcServerResponse;
import brave.rpc.RpcTracing;
import brave.sampler.SamplerFunction;

public final class RpcServerHandler
extends RpcHandler<RpcServerRequest, RpcServerResponse> {
    final Tracer tracer;
    final TraceContext.Extractor<RpcServerRequest> extractor;
    final SamplerFunction<RpcRequest> sampler;

    public static RpcServerHandler create(RpcTracing rpcTracing) {
        if (rpcTracing == null) {
            throw new NullPointerException("rpcTracing == null");
        }
        return new RpcServerHandler(rpcTracing);
    }

    RpcServerHandler(RpcTracing rpcTracing) {
        super(rpcTracing.serverRequestParser(), rpcTracing.serverResponseParser());
        this.tracer = rpcTracing.tracing().tracer();
        this.extractor = rpcTracing.tracing().propagation().extractor(RpcServerRequest.GETTER);
        this.sampler = rpcTracing.serverSampler();
    }

    public Span handleReceive(RpcServerRequest request) {
        Span span = this.nextSpan(this.extractor.extract((Object)request), request);
        return this.handleStart(request, span);
    }

    Span nextSpan(TraceContextOrSamplingFlags extracted, RpcServerRequest request) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = this.sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
    }

    public void handleSend(RpcServerResponse response, Span span) {
        this.handleFinish(response, span);
    }
}

