/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingConnection;
import brave.jms.TracingJMSContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;

class TracingConnectionFactory
implements QueueConnectionFactory,
TopicConnectionFactory {
    static final int TYPE_CF = 2;
    static final int TYPE_QUEUE_CF = 4;
    static final int TYPE_TOPIC_CF = 8;
    static final int TYPE_XA_CF = 16;
    static final int TYPE_XA_QUEUE_CF = 32;
    static final int TYPE_XA_TOPIC_CF = 64;
    final Object delegate;
    final JmsTracing jmsTracing;
    final int types;

    static ConnectionFactory create(ConnectionFactory delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("connectionFactory == null");
        }
        if (delegate instanceof TracingConnectionFactory) {
            return delegate;
        }
        return new TracingConnectionFactory(delegate, jmsTracing);
    }

    TracingConnectionFactory(Object delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        int types = 0;
        if (delegate instanceof ConnectionFactory) {
            types |= 2;
        }
        if (delegate instanceof QueueConnectionFactory) {
            types |= 4;
        }
        if (delegate instanceof TopicConnectionFactory) {
            types |= 8;
        }
        if (delegate instanceof XAConnectionFactory) {
            types |= 0x10;
        }
        if (delegate instanceof XAQueueConnectionFactory) {
            types |= 0x20;
        }
        if (delegate instanceof XATopicConnectionFactory) {
            types |= 0x40;
        }
        this.types = types;
    }

    public Connection createConnection() throws JMSException {
        this.checkConnectionFactory();
        return TracingConnection.create(((ConnectionFactory)this.delegate).createConnection(), this.jmsTracing);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        this.checkConnectionFactory();
        ConnectionFactory cf = (ConnectionFactory)this.delegate;
        return TracingConnection.create(cf.createConnection(userName, password), this.jmsTracing);
    }

    public JMSContext createContext() {
        this.checkConnectionFactory();
        return TracingJMSContext.create(((ConnectionFactory)this.delegate).createContext(), this.jmsTracing);
    }

    public JMSContext createContext(String userName, String password) {
        this.checkConnectionFactory();
        JMSContext ctx = ((ConnectionFactory)this.delegate).createContext(userName, password);
        return TracingJMSContext.create(ctx, this.jmsTracing);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        this.checkConnectionFactory();
        JMSContext ctx = ((ConnectionFactory)this.delegate).createContext(userName, password, sessionMode);
        return TracingJMSContext.create(ctx, this.jmsTracing);
    }

    public JMSContext createContext(int sessionMode) {
        this.checkConnectionFactory();
        JMSContext ctx = ((ConnectionFactory)this.delegate).createContext(sessionMode);
        return TracingJMSContext.create(ctx, this.jmsTracing);
    }

    void checkConnectionFactory() {
        if ((this.types & 2) != 2) {
            throw new IllegalStateException(this.delegate + " is not a ConnectionFactory");
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.checkQueueConnectionFactory();
        QueueConnectionFactory qcf = (QueueConnectionFactory)this.delegate;
        return TracingConnection.create((Connection)qcf.createQueueConnection(), this.jmsTracing);
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        this.checkQueueConnectionFactory();
        QueueConnectionFactory qcf = (QueueConnectionFactory)this.delegate;
        return TracingConnection.create((Connection)qcf.createQueueConnection(userName, password), this.jmsTracing);
    }

    void checkQueueConnectionFactory() {
        if ((this.types & 4) != 4) {
            throw new IllegalStateException(this.delegate + " is not a QueueConnectionFactory");
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.checkTopicConnectionFactory();
        TopicConnectionFactory qcf = (TopicConnectionFactory)this.delegate;
        return TracingConnection.create((Connection)qcf.createTopicConnection(), this.jmsTracing);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        this.checkTopicConnectionFactory();
        TopicConnectionFactory qcf = (TopicConnectionFactory)this.delegate;
        return TracingConnection.create((Connection)qcf.createTopicConnection(userName, password), this.jmsTracing);
    }

    void checkTopicConnectionFactory() {
        if ((this.types & 8) != 8) {
            throw new IllegalStateException(this.delegate + " is not a TopicConnectionFactory");
        }
    }
}

