/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.jodah.failsafe.internal;

import io.trino.jdbc.$internal.net.jodah.failsafe.ExecutionContext;
import io.trino.jdbc.$internal.net.jodah.failsafe.ExecutionResult;
import io.trino.jdbc.$internal.net.jodah.failsafe.event.ExecutionAttemptedEvent;
import io.trino.jdbc.$internal.net.jodah.failsafe.event.ExecutionCompletedEvent;
import io.trino.jdbc.$internal.net.jodah.failsafe.function.CheckedConsumer;

public interface EventListener {
    public void handle(Object var1, Throwable var2, ExecutionContext var3);

    public static <R> EventListener of(CheckedConsumer<? extends ExecutionCompletedEvent<R>> handler) {
        return (result, failure, context) -> {
            try {
                handler.accept(new ExecutionCompletedEvent<Object>(result, failure, context));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    public static <R> EventListener ofAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> handler) {
        return (result, failure, context) -> {
            try {
                handler.accept(new ExecutionAttemptedEvent<Object>(result, failure, context));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
    }

    default public void handle(ExecutionResult result, ExecutionContext context) {
        this.handle(result.getResult(), result.getFailure(), context);
    }
}

