/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.datatype.joda.ser;

import io.trino.jdbc.$internal.jackson.annotation.JsonFormat;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.databind.BeanProperty;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.JsonNode;
import io.trino.jdbc.$internal.jackson.databind.JsonSerializer;
import io.trino.jdbc.$internal.jackson.databind.SerializationFeature;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import io.trino.jdbc.$internal.jackson.databind.ser.ContextualSerializer;
import io.trino.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import io.trino.jdbc.$internal.jackson.datatype.joda.ser.JodaSerializerBase;
import java.lang.reflect.Type;

public abstract class JodaDateSerializerBase<T>
extends JodaSerializerBase<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected static final int FORMAT_STRING = 1;
    protected static final int FORMAT_TIMESTAMP = 2;
    protected static final int FORMAT_ARRAY = 3;
    protected final JacksonJodaDateFormat _format;
    protected final SerializationFeature _featureForNumeric;
    protected final int _defaultNumericShape;
    protected final int _shapeOverride;

    protected JodaDateSerializerBase(Class<T> type, JacksonJodaDateFormat format, SerializationFeature numericFeature, int defaultNumericShape, int shapeOverride) {
        super(type);
        this._format = format;
        this._featureForNumeric = numericFeature;
        this._defaultNumericShape = defaultNumericShape;
        this._shapeOverride = shapeOverride;
    }

    public abstract JodaDateSerializerBase<T> withFormat(JacksonJodaDateFormat var1, int var2);

    @Override
    public boolean isEmpty(SerializerProvider prov, T value) {
        return value == null;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value ann = this.findFormatOverrides(prov, property, this.handledType());
        if (ann != null) {
            int shapeOverride;
            Boolean useTimestamp;
            JsonFormat.Shape shape = ann.getShape();
            if (shape.isNumeric()) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 2;
            } else if (shape == JsonFormat.Shape.STRING) {
                useTimestamp = Boolean.FALSE;
                shapeOverride = 1;
            } else if (shape == JsonFormat.Shape.ARRAY) {
                useTimestamp = Boolean.TRUE;
                shapeOverride = 3;
            } else {
                useTimestamp = null;
                shapeOverride = this._shapeOverride;
            }
            JacksonJodaDateFormat format = this._format;
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            if ((format = format.with(ann)) != this._format || shapeOverride != this._shapeOverride) {
                return this.withFormat(format, shapeOverride);
            }
        }
        return this;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        switch (this._serializationShape(provider)) {
            case 2: {
                return this.createSchemaNode("array", true);
            }
            case 3: {
                return this.createSchemaNode("number", true);
            }
        }
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        switch (this._serializationShape(visitor.getProvider())) {
            case 2: {
                JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
                if (v2 == null) break;
                v2.numberType(JsonParser.NumberType.LONG);
                v2.format(JsonValueFormat.UTC_MILLISEC);
                break;
            }
            case 3: {
                JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
                if (v2 == null) break;
                v2.itemsFormat(JsonFormatTypes.INTEGER);
                break;
            }
            default: {
                JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
                if (v2 == null) break;
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }

    protected boolean writeWithZoneId(SerializerProvider provider) {
        return this._format.shouldWriteWithZoneId(provider);
    }

    protected int _serializationShape(SerializerProvider provider) {
        int shape = this._shapeOverride;
        if (shape == 0) {
            shape = this._format.useTimestamp(provider, this._featureForNumeric) ? this._defaultNumericShape : 1;
        }
        return shape;
    }
}

