/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.airlift.security.csr;

import io.trino.jdbc.$internal.airlift.security.der.DerUtils;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SignatureAlgorithmIdentifier {
    private static final int OBJECT_IDENTIFIER_TAG = 6;
    private static final Map<String, SignatureAlgorithmIdentifier> ALGORITHMS;
    private static final String SIGNATURE_OID_PREFIX = "Alg.Alias.Signature.OID.";
    private final String name;
    private final String oid;
    private final byte[] encoded;

    public static Map<String, SignatureAlgorithmIdentifier> getAllSignatureAlgorithmIdentifiers() {
        return ALGORITHMS;
    }

    public static SignatureAlgorithmIdentifier findSignatureAlgorithmIdentifier(String algorithmName) {
        SignatureAlgorithmIdentifier identifier = ALGORITHMS.get(algorithmName);
        Preconditions.checkArgument(identifier != null, "Unknown signature algorithm '%s'", (Object)algorithmName);
        return identifier;
    }

    public SignatureAlgorithmIdentifier(String name, String oid) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.oid = Objects.requireNonNull(oid, "oid is null");
        List parts = Splitter.on('.').splitToList(oid).stream().map(Integer::parseInt).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument(parts.size() >= 2, "at least 2 parts are required");
        try {
            ByteArrayOutputStream body = new ByteArrayOutputStream();
            body.write((Integer)parts.get(0) * 40 + (Integer)parts.get(1));
            for (Integer part : parts.subList(2, parts.size())) {
                SignatureAlgorithmIdentifier.writePart(body, part);
            }
            byte[] length = DerUtils.encodeLength(body.size());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(6);
            out.write(length);
            body.writeTo(out);
            this.encoded = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOid() {
        return this.oid;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAlgorithmIdentifier that = (SignatureAlgorithmIdentifier)o;
        return Objects.equals(this.oid, that.oid);
    }

    public int hashCode() {
        return Objects.hash(this.oid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("oid", this.oid).toString();
    }

    private static void writePart(OutputStream out, int number) throws IOException {
        if (number < 128) {
            out.write((byte)number);
            return;
        }
        int numberOfBits = 32 - Integer.numberOfLeadingZeros(number);
        int numberOfParts = (numberOfBits + 6) / 7;
        for (int i = 0; i < numberOfParts - 1; ++i) {
            int partToEncode = numberOfParts - i;
            int shiftSize = (partToEncode - 1) * 7;
            int part = number >>> shiftSize & 0x7F | 0x80;
            out.write(part);
        }
        out.write(number & 0x7F);
    }

    static {
        LinkedHashMap algorithms = new LinkedHashMap();
        for (Provider provider : Security.getProviders()) {
            for (Map.Entry entry : Maps.fromProperties(provider).entrySet()) {
                if (!((String)entry.getKey()).startsWith(SIGNATURE_OID_PREFIX)) continue;
                String oid = ((String)entry.getKey()).substring(SIGNATURE_OID_PREFIX.length());
                SignatureAlgorithmIdentifier algorithmIdentifier = new SignatureAlgorithmIdentifier((String)entry.getValue(), oid);
                algorithms.putIfAbsent(entry.getValue(), algorithmIdentifier);
            }
        }
        ALGORITHMS = ImmutableMap.copyOf(algorithms);
    }
}

