/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.grpc.auto.Metadata;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.remote.PayloadRegistry;
import com.alibaba.nacos.common.remote.exception.RemoteException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class GrpcUtils {
    public static Payload convert(Request request, RequestMeta meta) {
        Payload.Builder payloadBuilder = Payload.newBuilder();
        Metadata.Builder metaBuilder = Metadata.newBuilder();
        if (meta != null) {
            metaBuilder.putAllHeaders(request.getHeaders()).setType(request.getClass().getSimpleName());
        }
        metaBuilder.setClientIp(NetUtils.localIP());
        payloadBuilder.setMetadata(metaBuilder.build());
        byte[] jsonBytes = GrpcUtils.convertRequestToByte(request);
        return payloadBuilder.setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])jsonBytes))).build();
    }

    public static Payload convert(Request request) {
        Metadata newMeta = Metadata.newBuilder().setType(request.getClass().getSimpleName()).setClientIp(NetUtils.localIP()).putAllHeaders(request.getHeaders()).build();
        byte[] jsonBytes = GrpcUtils.convertRequestToByte(request);
        Payload.Builder builder = Payload.newBuilder();
        return builder.setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])jsonBytes))).setMetadata(newMeta).build();
    }

    public static Payload convert(Response response) {
        byte[] jsonBytes = JacksonUtils.toJsonBytes(response);
        Metadata.Builder metaBuilder = Metadata.newBuilder().setType(response.getClass().getSimpleName());
        return Payload.newBuilder().setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])jsonBytes))).setMetadata(metaBuilder.build()).build();
    }

    private static byte[] convertRequestToByte(Request request) {
        HashMap requestHeaders = new HashMap(request.getHeaders());
        request.clearHeaders();
        byte[] jsonBytes = JacksonUtils.toJsonBytes(request);
        request.putAllHeader(requestHeaders);
        return jsonBytes;
    }

    public static Object parse(Payload payload) {
        Class<?> classType = PayloadRegistry.getClassByType(payload.getMetadata().getType());
        if (classType != null) {
            ByteString byteString = payload.getBody().getValue();
            ByteBuffer byteBuffer = byteString.asReadOnlyByteBuffer();
            Object obj = JacksonUtils.toObj((InputStream)new ByteBufferBackedInputStream(byteBuffer), classType);
            if (obj instanceof Request) {
                ((Request)obj).putAllHeader(payload.getMetadata().getHeadersMap());
            }
            return obj;
        }
        throw new RemoteException(500, "Unknown payload type:" + payload.getMetadata().getType());
    }

    public static class PlainRequest {
        String type;
        Object body;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }
    }
}

