/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.core.context.GlobalLockConfigHolder;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalLockConfig;
import io.seata.core.model.GlobalStatus;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.TransactionHook;
import io.seata.tm.api.transaction.TransactionHookManager;
import io.seata.tm.api.transaction.TransactionInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalTemplate.class);

    /*
     * Exception decompiling
     */
    public Object execute(TransactionalExecutor business) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean existingTransaction(GlobalTransaction tx) {
        return tx != null;
    }

    private boolean notExistingTransaction(GlobalTransaction tx) {
        return tx == null;
    }

    private GlobalLockConfig replaceGlobalLockConfig(TransactionInfo info) {
        GlobalLockConfig myConfig = new GlobalLockConfig();
        myConfig.setLockRetryInterval(info.getLockRetryInterval());
        myConfig.setLockRetryTimes(info.getLockRetryTimes());
        return GlobalLockConfigHolder.setAndReturnPrevious((GlobalLockConfig)myConfig);
    }

    private void resumeGlobalLockConfig(GlobalLockConfig config) {
        if (config != null) {
            GlobalLockConfigHolder.setAndReturnPrevious((GlobalLockConfig)config);
        } else {
            GlobalLockConfigHolder.remove();
        }
    }

    private void completeTransactionAfterThrowing(TransactionInfo txInfo, GlobalTransaction tx, Throwable originalException) throws TransactionalExecutor.ExecutionException {
        if (txInfo != null && txInfo.rollbackOn(originalException)) {
            try {
                this.rollbackTransaction(tx, originalException);
            }
            catch (TransactionException txe) {
                throw new TransactionalExecutor.ExecutionException(tx, (Throwable)txe, TransactionalExecutor.Code.RollbackFailure, originalException);
            }
        } else {
            this.commitTransaction(tx);
        }
    }

    private void commitTransaction(GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeCommit();
            tx.commit();
            this.triggerAfterCommit();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.CommitFailure);
        }
    }

    private void rollbackTransaction(GlobalTransaction tx, Throwable originalException) throws TransactionException, TransactionalExecutor.ExecutionException {
        this.triggerBeforeRollback();
        tx.rollback();
        this.triggerAfterRollback();
        throw new TransactionalExecutor.ExecutionException(tx, GlobalStatus.RollbackRetrying.equals((Object)tx.getLocalStatus()) ? TransactionalExecutor.Code.RollbackRetrying : TransactionalExecutor.Code.RollbackDone, originalException);
    }

    private void beginTransaction(TransactionInfo txInfo, GlobalTransaction tx) throws TransactionalExecutor.ExecutionException {
        try {
            this.triggerBeforeBegin();
            tx.begin(txInfo.getTimeOut(), txInfo.getName());
            this.triggerAfterBegin();
        }
        catch (TransactionException txe) {
            throw new TransactionalExecutor.ExecutionException(tx, txe, TransactionalExecutor.Code.BeginFailure);
        }
    }

    private void triggerBeforeBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeBegin in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterBegin() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterBegin();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterBegin in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerBeforeRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterRollback() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterRollback();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterRollback in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerBeforeCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.beforeCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute beforeCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterCommit() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCommit();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCommit in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void triggerAfterCompletion() {
        for (TransactionHook hook : this.getCurrentHooks()) {
            try {
                hook.afterCompletion();
            }
            catch (Exception e) {
                LOGGER.error("Failed execute afterCompletion in hook {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void cleanUp() {
        TransactionHookManager.clear();
    }

    private List<TransactionHook> getCurrentHooks() {
        return TransactionHookManager.getHooks();
    }
}

