/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.ReflectionUtil;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.AbstractedRemotingParser;

public class HSFRemotingParser
extends AbstractedRemotingParser {
    private static volatile boolean isHsf;

    @Override
    public boolean isRemoting(Object bean, String beanName) {
        return isHsf && (this.isReference(bean, beanName) || this.isService(bean, beanName));
    }

    @Override
    public boolean isReference(Object bean, String beanName) {
        String beanClassName = bean.getClass().getName();
        return isHsf && ("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean".equals(beanClassName) || "org.springframework.beans.factory.FactoryBean".equals(beanClassName));
    }

    @Override
    public boolean isService(Object bean, String beanName) {
        String beanClassName = bean.getClass().getName();
        return isHsf && "com.taobao.hsf.app.spring.util.HSFSpringProviderBean".equals(beanClassName);
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        try {
            if (this.isReference(bean, beanName)) {
                Object consumerBean = ReflectionUtil.getFieldValue((Object)bean, (String)"consumerBean");
                Object metadata = ReflectionUtil.invokeMethod((Object)consumerBean, (String)"getMetadata");
                Class interfaceClass = (Class)ReflectionUtil.invokeMethod((Object)metadata, (String)"getIfClazz");
                String interfaceClassName = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getInterfaceName");
                String uniqueId = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getVersion");
                String group = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getGroup");
                RemotingDesc serviceBeanDesc = new RemotingDesc();
                serviceBeanDesc.setInterfaceClass(interfaceClass);
                serviceBeanDesc.setInterfaceClassName(interfaceClassName);
                serviceBeanDesc.setUniqueId(uniqueId);
                serviceBeanDesc.setGroup(group);
                serviceBeanDesc.setProtocol((short)8);
                return serviceBeanDesc;
            }
            if (this.isService(bean, beanName)) {
                Object consumerBean = ReflectionUtil.getFieldValue((Object)bean, (String)"providerBean");
                Object metadata = ReflectionUtil.invokeMethod((Object)consumerBean, (String)"getMetadata");
                String interfaceClassName = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getInterfaceName");
                Class<?> interfaceClass = Class.forName(interfaceClassName);
                String uniqueId = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getVersion");
                String group = (String)ReflectionUtil.invokeMethod((Object)metadata, (String)"getGroup");
                RemotingDesc serviceBeanDesc = new RemotingDesc();
                serviceBeanDesc.setInterfaceClass(interfaceClass);
                serviceBeanDesc.setInterfaceClassName(interfaceClassName);
                serviceBeanDesc.setUniqueId(uniqueId);
                serviceBeanDesc.setGroup(group);
                Object targetBean = ReflectionUtil.getFieldValue((Object)metadata, (String)"target");
                serviceBeanDesc.setTargetBean(targetBean);
                serviceBeanDesc.setProtocol((short)8);
                return serviceBeanDesc;
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(t);
        }
        return null;
    }

    @Override
    public short getProtocol() {
        return 8;
    }

    static {
        try {
            Class.forName("com.taobao.hsf.app.api.util.HSFApiConsumerBean");
            Class.forName("com.taobao.hsf.app.api.util.HSFApiProviderBean");
            Class.forName("com.taobao.hsf.app.spring.util.HSFSpringConsumerBean");
            Class.forName("com.taobao.hsf.app.spring.util.HSFSpringProviderBean");
            isHsf = true;
        }
        catch (ClassNotFoundException e) {
            isHsf = false;
        }
    }
}

