/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import io.seata.common.util.CollectionUtils;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLRecognizerFactory;
import io.seata.sqlparser.druid.SQLOperateRecognizerHolder;
import io.seata.sqlparser.druid.SQLOperateRecognizerHolderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DruidSQLRecognizerFactoryImpl
implements SQLRecognizerFactory {
    DruidSQLRecognizerFactoryImpl() {
    }

    public List<SQLRecognizer> create(String sql, String dbType) {
        List asts = SQLUtils.parseStatements((String)sql, (String)dbType);
        if (CollectionUtils.isEmpty((Collection)asts)) {
            throw new UnsupportedOperationException("Unsupported SQL: " + sql);
        }
        if (asts.size() > 1 && !asts.stream().allMatch(statement -> statement instanceof SQLUpdateStatement) && !asts.stream().allMatch(statement -> statement instanceof SQLDeleteStatement)) {
            throw new UnsupportedOperationException("ONLY SUPPORT SAME TYPE (UPDATE OR DELETE) MULTI SQL -" + sql);
        }
        ArrayList<SQLRecognizer> recognizers = null;
        SQLRecognizer recognizer = null;
        for (SQLStatement ast : asts) {
            SQLOperateRecognizerHolder recognizerHolder = SQLOperateRecognizerHolderFactory.getSQLRecognizerHolder(dbType.toLowerCase());
            if (ast instanceof SQLInsertStatement) {
                recognizer = recognizerHolder.getInsertRecognizer(sql, ast);
            } else if (ast instanceof SQLUpdateStatement) {
                recognizer = recognizerHolder.getUpdateRecognizer(sql, ast);
            } else if (ast instanceof SQLDeleteStatement) {
                recognizer = recognizerHolder.getDeleteRecognizer(sql, ast);
            } else if (ast instanceof SQLSelectStatement) {
                recognizer = recognizerHolder.getSelectForUpdateRecognizer(sql, ast);
            }
            if (recognizer == null || !recognizer.isSqlSyntaxSupports()) continue;
            if (recognizers == null) {
                recognizers = new ArrayList<SQLRecognizer>();
            }
            recognizers.add(recognizer);
        }
        return recognizers;
    }
}

