/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.hussar.extend;

import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.ShutdownHook;
import io.seata.core.rpc.netty.RmNettyRemotingClient;
import io.seata.core.rpc.netty.TmNettyRemotingClient;
import io.seata.rm.RMClient;
import io.seata.spring.boot.autoconfigure.anno.HussarGlobalLock;
import io.seata.spring.boot.autoconfigure.hussar.extend.HussarTransactionalInterceptor;
import io.seata.spring.boot.autoconfigure.hussar.extend.MethodDesc;
import io.seata.spring.tcc.TccActionInterceptor;
import io.seata.spring.util.SpringProxyUtils;
import io.seata.spring.util.TCCBeanParserUtils;
import io.seata.tm.TMClient;
import io.seata.tm.api.FailureHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class HussarSeataTransactionScanner
extends AbstractAutoProxyCreator
implements ConfigurationChangeListener,
InitializingBean,
ApplicationContextAware,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarSeataTransactionScanner.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private static final Set<String> PROXYED_SET = new HashSet<String>();
    private MethodInterceptor interceptor;
    private MethodInterceptor globalTransactionalInterceptor;
    private final String applicationId;
    private final String txServiceGroup;
    private final int mode;
    private String accessKey;
    private String secretKey;
    private volatile boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final FailureHandler failureHandlerHook;
    private ApplicationContext applicationContext;

    public HussarSeataTransactionScanner(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public HussarSeataTransactionScanner(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, null);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, failureHandlerHook);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, int mode, FailureHandler failureHandlerHook) {
        this.setOrder(1024);
        this.setProxyTargetClass(true);
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.mode = mode;
        this.failureHandlerHook = failureHandlerHook;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    private void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException(String.format("applicationId: %s, txServiceGroup: %s", this.applicationId, this.txServiceGroup));
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup, (String)this.accessKey, (String)this.secretKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    private void registerSpringShutdownHook() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            ShutdownHook.removeRuntimeShutdownHook();
        }
        ShutdownHook.getInstance().addDisposable((Disposable)TmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
        ShutdownHook.getInstance().addDisposable((Disposable)RmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        try {
            Set<String> set = PROXYED_SET;
            synchronized (set) {
                if (PROXYED_SET.contains(beanName)) {
                    return bean;
                }
                this.interceptor = null;
                if (TCCBeanParserUtils.isTccAutoProxy((Object)bean, (String)beanName, (ApplicationContext)this.applicationContext)) {
                    this.interceptor = new TccActionInterceptor(TCCBeanParserUtils.getRemotingDesc((String)beanName));
                    ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{(ConfigurationChangeListener)this.interceptor});
                } else {
                    Class serviceInterface = SpringProxyUtils.findTargetClass((Object)bean);
                    Class[] interfacesIfJdk = SpringProxyUtils.findInterfaces((Object)bean);
                    if (!this.existsAnnotation(new Class[]{serviceInterface}) && !this.existsAnnotation(interfacesIfJdk)) {
                        return bean;
                    }
                    if (this.globalTransactionalInterceptor == null) {
                        this.globalTransactionalInterceptor = new HussarTransactionalInterceptor(this.failureHandlerHook);
                        ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{(ConfigurationChangeListener)this.globalTransactionalInterceptor});
                    }
                    this.interceptor = this.globalTransactionalInterceptor;
                }
                LOGGER.info("Bean[{}] with name [{}] would use interceptor [{}]", new Object[]{bean.getClass().getName(), beanName, this.interceptor.getClass().getName()});
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport((Object)bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        advised.addAdvisor(0, avr);
                    }
                }
                PROXYED_SET.add(beanName);
                return bean;
            }
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private boolean existsAnnotation(Class<?>[] classes) {
        if (CollectionUtils.isNotEmpty((Object[])classes)) {
            for (Class<?> clazz : classes) {
                Method[] methods;
                if (clazz == null) continue;
                HussarTransactional trxAnno = clazz.getAnnotation(HussarTransactional.class);
                if (trxAnno != null) {
                    return true;
                }
                for (Method method : methods = clazz.getMethods()) {
                    trxAnno = method.getAnnotation(HussarTransactional.class);
                    if (trxAnno != null) {
                        return true;
                    }
                    HussarGlobalLock lockAnno = method.getAnnotation(HussarGlobalLock.class);
                    if (lockAnno == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private MethodDesc makeMethodDesc(HussarTransactional anno, Method method) {
        return new MethodDesc(anno, method);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void afterPropertiesSet() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{this});
            return;
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.initClient();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setBeanFactory((BeanFactory)applicationContext);
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            this.disableGlobalTransaction = Boolean.parseBoolean(event.getNewValue().trim());
            if (!this.disableGlobalTransaction && this.initialized.compareAndSet(false, true)) {
                LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disableGlobalTransaction, event.getNewValue()});
                this.initClient();
            }
        }
    }
}

