/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.spring.annotation.ScannerChecker;
import io.seata.spring.boot.autoconfigure.SeataCoreAutoConfiguration;
import io.seata.spring.boot.autoconfigure.hussar.extend.HussarSeataTransactionScanner;
import io.seata.spring.boot.autoconfigure.properties.SeataProperties;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@AutoConfigureAfter(value={SeataCoreAutoConfiguration.class})
public class SeataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SeataAutoConfiguration.class);

    @Bean(value={"failureHandler"})
    @ConditionalOnMissingBean(value={FailureHandler.class})
    public FailureHandler failureHandler() {
        return new DefaultFailureHandlerImpl();
    }

    @Bean(value={"hussarSeataTransactionScanner"})
    @DependsOn(value={"springApplicationContextProvider", "failureHandler"})
    @ConditionalOnMissingBean(value={HussarSeataTransactionScanner.class})
    public HussarSeataTransactionScanner hussarSeataTransactionScanner(SeataProperties seataProperties, FailureHandler failureHandler, ConfigurableListableBeanFactory beanFactory, @Autowired(required=false) List<ScannerChecker> scannerCheckers) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Automatically configure Seata");
        }
        HussarSeataTransactionScanner.setBeanFactory(beanFactory);
        HussarSeataTransactionScanner.addScannerCheckers(EnhancedServiceLoader.loadAll(ScannerChecker.class));
        HussarSeataTransactionScanner.addScannerCheckers(scannerCheckers);
        HussarSeataTransactionScanner.addScannablePackages(seataProperties.getScanPackages());
        HussarSeataTransactionScanner.addScannerExcludeBeanNames(seataProperties.getExcludesForScanning());
        HussarSeataTransactionScanner.setAccessKey(seataProperties.getAccessKey());
        HussarSeataTransactionScanner.setSecretKey(seataProperties.getSecretKey());
        return new HussarSeataTransactionScanner(seataProperties.getApplicationId(), seataProperties.getTxServiceGroup(), failureHandler);
    }
}

