/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.hussar.extend;

import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.ShutdownHook;
import io.seata.core.rpc.netty.RmNettyRemotingClient;
import io.seata.core.rpc.netty.TmNettyRemotingClient;
import io.seata.rm.RMClient;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.spring.annotation.ScannerChecker;
import io.seata.spring.annotation.SeataInterceptor;
import io.seata.spring.annotation.SeataInterceptorPosition;
import io.seata.spring.annotation.scannercheckers.PackageScannerChecker;
import io.seata.spring.boot.autoconfigure.anno.HussarGlobalLock;
import io.seata.spring.boot.autoconfigure.hussar.extend.HussarTransactionalInterceptor;
import io.seata.spring.boot.autoconfigure.hussar.extend.MethodDesc;
import io.seata.spring.tcc.TccActionInterceptor;
import io.seata.spring.util.OrderUtil;
import io.seata.spring.util.SpringProxyUtils;
import io.seata.spring.util.TCCBeanParserUtils;
import io.seata.tm.TMClient;
import io.seata.tm.api.FailureHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class HussarSeataTransactionScanner
extends AbstractAutoProxyCreator
implements ConfigurationChangeListener,
InitializingBean,
ApplicationContextAware,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarSeataTransactionScanner.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private static final String SPRING_TRANSACTION_INTERCEPTOR_CLASS_NAME = "org.springframework.transaction.interceptor.TransactionInterceptor";
    private static final Set<String> PROXYED_SET = new HashSet<String>();
    private static final Set<String> EXCLUDE_BEAN_NAME_SET = new HashSet<String>();
    private static final Set<ScannerChecker> SCANNER_CHECKER_SET = new LinkedHashSet<ScannerChecker>();
    private static ConfigurableListableBeanFactory beanFactory;
    private MethodInterceptor interceptor;
    private MethodInterceptor globalTransactionalInterceptor;
    private final String applicationId;
    private final String txServiceGroup;
    private final int mode;
    private static String accessKey;
    private static String secretKey;
    private volatile boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final FailureHandler failureHandlerHook;
    private ApplicationContext applicationContext;

    public HussarSeataTransactionScanner(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public HussarSeataTransactionScanner(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, null);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, failureHandlerHook);
    }

    public HussarSeataTransactionScanner(String applicationId, String txServiceGroup, int mode, FailureHandler failureHandlerHook) {
        this.setOrder(1024);
        this.setProxyTargetClass(true);
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.mode = mode;
        this.failureHandlerHook = failureHandlerHook;
    }

    public static void setAccessKey(String accessKey) {
        HussarSeataTransactionScanner.accessKey = accessKey;
    }

    public static void setSecretKey(String secretKey) {
        HussarSeataTransactionScanner.secretKey = secretKey;
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    private void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if ("my_test_tx_group".equals(this.txServiceGroup)) {
            LOGGER.warn("the default value of seata.tx-service-group: {} has already changed to {} since Seata 1.5, please change your default configuration as soon as possible and we don't recommend you to use default tx-service-group's value provided by seata", (Object)"my_test_tx_group", (Object)"default_tx_group");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException(String.format("applicationId: %s, txServiceGroup: %s", this.applicationId, this.txServiceGroup));
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup, (String)accessKey, (String)secretKey);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    private void registerSpringShutdownHook() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            ShutdownHook.removeRuntimeShutdownHook();
        }
        ShutdownHook.getInstance().addDisposable((Disposable)TmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
        ShutdownHook.getInstance().addDisposable((Disposable)RmNettyRemotingClient.getInstance((String)this.applicationId, (String)this.txServiceGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (!this.doCheckers(bean, beanName)) {
            return bean;
        }
        try {
            Set<String> set = PROXYED_SET;
            synchronized (set) {
                if (PROXYED_SET.contains(beanName)) {
                    return bean;
                }
                this.interceptor = null;
                if (TCCBeanParserUtils.isTccAutoProxy((Object)bean, (String)beanName, (ApplicationContext)this.applicationContext)) {
                    TCCBeanParserUtils.initTccFenceCleanTask((RemotingDesc)TCCBeanParserUtils.getRemotingDesc((String)beanName), (ApplicationContext)this.applicationContext);
                    this.interceptor = new TccActionInterceptor(TCCBeanParserUtils.getRemotingDesc((String)beanName));
                    ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{(ConfigurationChangeListener)this.interceptor});
                } else {
                    Class serviceInterface = SpringProxyUtils.findTargetClass((Object)bean);
                    Class[] interfacesIfJdk = SpringProxyUtils.findInterfaces((Object)bean);
                    if (!this.existsAnnotation(new Class[]{serviceInterface}) && !this.existsAnnotation(interfacesIfJdk)) {
                        return bean;
                    }
                    if (this.globalTransactionalInterceptor == null) {
                        this.globalTransactionalInterceptor = new HussarTransactionalInterceptor(this.failureHandlerHook);
                        ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{(ConfigurationChangeListener)this.globalTransactionalInterceptor});
                    }
                    this.interceptor = this.globalTransactionalInterceptor;
                }
                LOGGER.info("Bean[{}] with name [{}] would use interceptor [{}]", new Object[]{bean.getClass().getName(), beanName, this.interceptor.getClass().getName()});
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport((Object)bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        int pos = this.findAddSeataAdvisorPosition(advised, avr);
                        advised.addAdvisor(pos, avr);
                    }
                }
                PROXYED_SET.add(beanName);
                return bean;
            }
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private boolean doCheckers(Object bean, String beanName) {
        if (PROXYED_SET.contains(beanName) || EXCLUDE_BEAN_NAME_SET.contains(beanName) || FactoryBean.class.isAssignableFrom(bean.getClass())) {
            return false;
        }
        if (!SCANNER_CHECKER_SET.isEmpty()) {
            for (ScannerChecker checker : SCANNER_CHECKER_SET) {
                try {
                    if (checker.check(bean, beanName, beanFactory)) continue;
                    return false;
                }
                catch (Exception e) {
                    LOGGER.error("Do check failed: beanName={}, checker={}", new Object[]{beanName, checker.getClass().getSimpleName(), e});
                }
            }
        }
        return true;
    }

    private int findAddSeataAdvisorPosition(AdvisedSupport advised, Advisor seataAdvisor) {
        int seataOrder = OrderUtil.getOrder((Object)seataAdvisor);
        SeataInterceptorPosition seataInterceptorPosition = this.getSeataInterceptorPosition(seataAdvisor);
        if (SeataInterceptorPosition.Any == seataInterceptorPosition) {
            if (seataOrder == Integer.MAX_VALUE) {
                return advised.getAdvisors().length;
            }
            if (seataOrder == Integer.MIN_VALUE) {
                return 0;
            }
        } else {
            Integer position = this.computePositionIfHasTransactionInterceptor(advised, seataAdvisor, seataInterceptorPosition, seataOrder);
            if (position != null) {
                return position;
            }
        }
        return this.findPositionInAdvisors(advised.getAdvisors(), seataAdvisor);
    }

    @Nullable
    private Integer computePositionIfHasTransactionInterceptor(AdvisedSupport advised, Advisor seataAdvisor, SeataInterceptorPosition seataInterceptorPosition, int seataOrder) {
        int newSeataOrder;
        Advisor otherAdvisor = null;
        Integer transactionInterceptorPosition = null;
        Integer transactionInterceptorOrder = null;
        int l = advised.getAdvisors().length;
        for (int i = 0; i < l; ++i) {
            otherAdvisor = advised.getAdvisors()[i];
            if (!this.isTransactionInterceptor(otherAdvisor)) continue;
            transactionInterceptorPosition = i;
            transactionInterceptorOrder = OrderUtil.getOrder((Object)otherAdvisor);
            break;
        }
        if (transactionInterceptorPosition == null) {
            return null;
        }
        Advice seataAdvice = seataAdvisor.getAdvice();
        if (SeataInterceptorPosition.AfterTransaction == seataInterceptorPosition && OrderUtil.higherThan((Integer)seataOrder, transactionInterceptorOrder)) {
            newSeataOrder = OrderUtil.lower((Integer)transactionInterceptorOrder, (int)1);
            ((SeataInterceptor)seataAdvice).setOrder(newSeataOrder);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The {}'s order '{}' is higher or equals than {}'s order '{}' , reset {}'s order to lower order '{}'.", new Object[]{seataAdvice.getClass().getSimpleName(), seataOrder, otherAdvisor.getAdvice().getClass().getSimpleName(), transactionInterceptorOrder, seataAdvice.getClass().getSimpleName(), newSeataOrder});
            }
            return transactionInterceptorPosition + 1;
        }
        if (SeataInterceptorPosition.BeforeTransaction == seataInterceptorPosition && OrderUtil.lowerThan((Integer)seataOrder, transactionInterceptorOrder)) {
            newSeataOrder = OrderUtil.higher((Integer)transactionInterceptorOrder, (int)1);
            ((SeataInterceptor)seataAdvice).setOrder(newSeataOrder);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The {}'s order '{}' is lower or equals than {}'s order '{}' , reset {}'s order to higher order '{}'.", new Object[]{seataAdvice.getClass().getSimpleName(), seataOrder, otherAdvisor.getAdvice().getClass().getSimpleName(), transactionInterceptorOrder, seataAdvice.getClass().getSimpleName(), newSeataOrder});
            }
            return transactionInterceptorPosition;
        }
        return null;
    }

    private int findPositionInAdvisors(Advisor[] advisors, Advisor seataAdvisor) {
        int l = advisors.length;
        for (int i = 0; i < l; ++i) {
            Advisor advisor = advisors[i];
            if (!OrderUtil.higherOrEquals((Advisor)seataAdvisor, (Advisor)advisor)) continue;
            return i;
        }
        return advisors.length;
    }

    private SeataInterceptorPosition getSeataInterceptorPosition(Advisor seataAdvisor) {
        Advice seataAdvice = seataAdvisor.getAdvice();
        if (seataAdvice instanceof SeataInterceptor) {
            return ((SeataInterceptor)seataAdvice).getPosition();
        }
        return SeataInterceptorPosition.Any;
    }

    private boolean isTransactionInterceptor(Advisor advisor) {
        return SPRING_TRANSACTION_INTERCEPTOR_CLASS_NAME.equals(advisor.getAdvice().getClass().getName());
    }

    private boolean existsAnnotation(Class<?>[] classes) {
        if (CollectionUtils.isNotEmpty((Object[])classes)) {
            for (Class<?> clazz : classes) {
                Method[] methods;
                if (clazz == null) continue;
                HussarTransactional trxAnno = clazz.getAnnotation(HussarTransactional.class);
                if (trxAnno != null) {
                    return true;
                }
                for (Method method : methods = clazz.getMethods()) {
                    trxAnno = method.getAnnotation(HussarTransactional.class);
                    if (trxAnno != null) {
                        return true;
                    }
                    HussarGlobalLock lockAnno = method.getAnnotation(HussarGlobalLock.class);
                    if (lockAnno == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private MethodDesc makeMethodDesc(HussarTransactional anno, Method method) {
        return new MethodDesc(anno, method);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void afterPropertiesSet() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            ConfigurationCache.addConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{this});
            return;
        }
        if (this.initialized.compareAndSet(false, true)) {
            this.initClient();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setBeanFactory((BeanFactory)applicationContext);
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            this.disableGlobalTransaction = Boolean.parseBoolean(event.getNewValue().trim());
            if (!this.disableGlobalTransaction && this.initialized.compareAndSet(false, true)) {
                LOGGER.info("{} config changed, old value:true, new value:{}", (Object)"service.disableGlobalTransaction", (Object)event.getNewValue());
                this.initClient();
                ConfigurationCache.removeConfigListener((String)"service.disableGlobalTransaction", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{this});
            }
        }
    }

    public static void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        HussarSeataTransactionScanner.beanFactory = beanFactory;
    }

    public static void addScannablePackages(String ... packages) {
        PackageScannerChecker.addScannablePackages((String[])packages);
    }

    public static void addScannerCheckers(Collection<ScannerChecker> scannerCheckers) {
        if (CollectionUtils.isNotEmpty(scannerCheckers)) {
            scannerCheckers.remove(null);
            SCANNER_CHECKER_SET.addAll(scannerCheckers);
        }
    }

    public static void addScannerCheckers(ScannerChecker ... scannerCheckers) {
        if (ArrayUtils.isNotEmpty((Object[])scannerCheckers)) {
            HussarSeataTransactionScanner.addScannerCheckers(Arrays.asList(scannerCheckers));
        }
    }

    public static void addScannerExcludeBeanNames(String ... beanNames) {
        if (ArrayUtils.isNotEmpty((Object[])beanNames)) {
            EXCLUDE_BEAN_NAME_SET.addAll(Arrays.asList(beanNames));
        }
    }
}

