/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.hussar.extend;

import com.google.common.eventbus.Subscribe;
import com.jxdinfo.hussar.platform.core.utils.EnumUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.event.Event;
import io.seata.core.event.EventBus;
import io.seata.core.event.GuavaEventBus;
import io.seata.core.model.GlobalLockConfig;
import io.seata.rm.GlobalLockExecutor;
import io.seata.rm.GlobalLockTemplate;
import io.seata.spring.annotation.AspectTransactional;
import io.seata.spring.annotation.SeataInterceptor;
import io.seata.spring.annotation.SeataInterceptorPosition;
import io.seata.spring.boot.autoconfigure.anno.HussarGlobalLock;
import io.seata.spring.event.DegradeCheckEvent;
import io.seata.tm.TransactionManagerHolder;
import io.seata.tm.api.DefaultFailureHandlerImpl;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.TransactionalTemplate;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.Propagation;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public class HussarTransactionalInterceptor
implements ConfigurationChangeListener,
MethodInterceptor,
SeataInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarTransactionalInterceptor.class);
    private static final FailureHandler DEFAULT_FAIL_HANDLER = new DefaultFailureHandlerImpl();
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final GlobalLockTemplate globalLockTemplate = new GlobalLockTemplate();
    private final FailureHandler failureHandler;
    private volatile boolean disable;
    private int order;
    protected AspectTransactional aspectTransactional;
    private static int degradeCheckPeriod;
    private static volatile boolean degradeCheck;
    private static int degradeCheckAllowTimes;
    private static volatile Integer degradeNum;
    private static volatile Integer reachNum;
    private static final EventBus EVENT_BUS;
    private static ScheduledThreadPoolExecutor executor;
    private static int defaultGlobalTransactionTimeout;

    private void initDefaultGlobalTransactionTimeout() {
        if (defaultGlobalTransactionTimeout <= 0) {
            int defaultGlobalTransactionTimeout;
            try {
                defaultGlobalTransactionTimeout = ConfigurationFactory.getInstance().getInt("client.tm.defaultGlobalTransactionTimeout", 60000);
            }
            catch (Exception e) {
                LOGGER.error("Illegal global transaction timeout value: " + e.getMessage());
                defaultGlobalTransactionTimeout = 60000;
            }
            if (defaultGlobalTransactionTimeout <= 0) {
                LOGGER.warn("Global transaction timeout value '{}' is illegal, and has been reset to the default value '{}'", (Object)defaultGlobalTransactionTimeout, (Object)60000);
                defaultGlobalTransactionTimeout = 60000;
            }
            HussarTransactionalInterceptor.defaultGlobalTransactionTimeout = defaultGlobalTransactionTimeout;
        }
    }

    public HussarTransactionalInterceptor() {
        this(null);
    }

    public HussarTransactionalInterceptor(FailureHandler failureHandler) {
        this.failureHandler = failureHandler == null ? DEFAULT_FAIL_HANDLER : failureHandler;
        this.disable = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
        this.order = ConfigurationFactory.getInstance().getInt("client.tm.interceptorOrder", -2147482648);
        degradeCheck = ConfigurationFactory.getInstance().getBoolean("client.tm.degradeCheck", false);
        if (degradeCheck) {
            ConfigurationCache.addConfigListener((String)"client.tm.degradeCheck", (ConfigurationChangeListener[])new ConfigurationChangeListener[]{this});
            degradeCheckPeriod = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckPeriod", 2000);
            degradeCheckAllowTimes = ConfigurationFactory.getInstance().getInt("client.tm.degradeCheckAllowTimes", 10);
            EVENT_BUS.register((Object)this);
            if (degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
                HussarTransactionalInterceptor.startDegradeCheck();
            }
        }
        this.initDefaultGlobalTransactionTimeout();
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Class targetClass = methodInvocation.getThis() != null ? AopUtils.getTargetClass((Object)methodInvocation.getThis()) : null;
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)methodInvocation.getMethod(), (Class)targetClass);
        if (specificMethod != null && !specificMethod.getDeclaringClass().equals(Object.class)) {
            boolean localDisable;
            Method method = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
            HussarTransactional globalTransactionalAnnotation = this.getAnnotation(method, targetClass, HussarTransactional.class);
            HussarGlobalLock globalLockAnnotation = this.getAnnotation(method, targetClass, HussarGlobalLock.class);
            boolean bl = localDisable = this.disable || degradeCheck && degradeNum >= degradeCheckAllowTimes;
            if (!localDisable) {
                if (globalTransactionalAnnotation != null || this.aspectTransactional != null) {
                    AspectTransactional transactional;
                    if (globalTransactionalAnnotation != null) {
                        Optional nameof = EnumUtil.nameof(Propagation.class, propagation -> propagation.name().equals(globalTransactionalAnnotation.propagation().name()));
                        transactional = new AspectTransactional(globalTransactionalAnnotation.timeout(), "", globalTransactionalAnnotation.rollbackFor(), globalTransactionalAnnotation.noRollbackForClassName(), globalTransactionalAnnotation.noRollbackFor(), globalTransactionalAnnotation.noRollbackForClassName(), nameof.orElse(Propagation.REQUIRED), 0, -1);
                    } else {
                        transactional = this.aspectTransactional;
                    }
                    return this.handleGlobalTransaction(methodInvocation, transactional);
                }
                if (globalLockAnnotation != null) {
                    return this.handleGlobalLock(methodInvocation, globalLockAnnotation);
                }
            }
        }
        return methodInvocation.proceed();
    }

    Object handleGlobalLock(final MethodInvocation methodInvocation, final HussarGlobalLock globalLockAnno) throws Throwable {
        return this.globalLockTemplate.execute(new GlobalLockExecutor(){

            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            public GlobalLockConfig getGlobalLockConfig() {
                GlobalLockConfig config = new GlobalLockConfig();
                config.setLockRetryInterval(globalLockAnno.lockRetryInternal());
                config.setLockRetryTimes(globalLockAnno.lockRetryTimes());
                return config;
            }
        });
    }

    Object handleGlobalTransaction(final MethodInvocation methodInvocation, final AspectTransactional aspectTransactional) throws Throwable {
        boolean succeed = true;
        try {
            Object object = this.transactionalTemplate.execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    return methodInvocation.proceed();
                }

                public String name() {
                    String name = aspectTransactional.getName();
                    if (!StringUtils.isNullOrEmpty((String)name)) {
                        return name;
                    }
                    return HussarTransactionalInterceptor.this.formatMethod(methodInvocation.getMethod());
                }

                public TransactionInfo getTransactionInfo() {
                    int timeout = aspectTransactional.getTimeoutMills();
                    if (timeout <= 0 || timeout == 60000) {
                        timeout = defaultGlobalTransactionTimeout;
                    }
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(timeout);
                    transactionInfo.setName(this.name());
                    transactionInfo.setPropagation(aspectTransactional.getPropagation());
                    transactionInfo.setLockRetryInterval(aspectTransactional.getLockRetryInterval());
                    transactionInfo.setLockRetryTimes(aspectTransactional.getLockRetryTimes());
                    LinkedHashSet<Object> rollbackRules = new LinkedHashSet<Object>();
                    for (Class clazz : aspectTransactional.getRollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getRollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class clazz : aspectTransactional.getNoRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getNoRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
            return object;
        }
        catch (TransactionalExecutor.ExecutionException e) {
            TransactionalExecutor.Code code = e.getCode();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    succeed = false;
                    this.failureHandler.onBeginFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case CommitFailure: {
                    succeed = false;
                    this.failureHandler.onCommitFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(e.getTransaction(), e.getOriginalException());
                    throw e.getOriginalException();
                }
                case RollbackRetrying: {
                    this.failureHandler.onRollbackRetrying(e.getTransaction(), e.getOriginalException());
                    throw e.getOriginalException();
                }
            }
            throw new ShouldNeverHappenException(String.format("Unknown TransactionalExecutor.Code: %s", code));
        }
        finally {
            if (degradeCheck) {
                EVENT_BUS.post((Event)new DegradeCheckEvent(succeed));
            }
        }
    }

    public <T extends Annotation> T getAnnotation(Method method, Class<?> targetClass, Class<T> annotationClass) {
        return (T)((Annotation)Optional.ofNullable(method).map(m -> m.getAnnotation(annotationClass)).orElse(Optional.ofNullable(targetClass).map(t -> t.getAnnotation(annotationClass)).orElse(null)));
    }

    private String formatMethod(Method method) {
        StringBuilder sb = new StringBuilder(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(", ");
        }
        return sb.append(")").toString();
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disable, event.getNewValue()});
            this.disable = Boolean.parseBoolean(event.getNewValue().trim());
        } else if ("client.tm.degradeCheck".equals(event.getDataId()) && !(degradeCheck = Boolean.parseBoolean(event.getNewValue()))) {
            degradeNum = 0;
        }
    }

    private static void startDegradeCheck() {
        executor.scheduleAtFixedRate(() -> {
            if (degradeCheck) {
                try {
                    String xid = TransactionManagerHolder.get().begin(null, null, "degradeCheck", 60000);
                    TransactionManagerHolder.get().commit(xid);
                    EVENT_BUS.post((Event)new DegradeCheckEvent(true));
                }
                catch (Exception e) {
                    EVENT_BUS.post((Event)new DegradeCheckEvent(false));
                }
            }
        }, degradeCheckPeriod, degradeCheckPeriod, TimeUnit.MILLISECONDS);
    }

    @Subscribe
    public static void onDegradeCheck(DegradeCheckEvent event) {
        if (event.isRequestSuccess()) {
            if (degradeNum >= degradeCheckAllowTimes) {
                Integer n = reachNum;
                Integer n2 = reachNum = Integer.valueOf(reachNum + 1);
                if (reachNum >= degradeCheckAllowTimes) {
                    reachNum = 0;
                    degradeNum = 0;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("the current global transaction has been restored");
                    }
                }
            } else if (degradeNum != 0) {
                degradeNum = 0;
            }
        } else if (degradeNum < degradeCheckAllowTimes) {
            Integer n = degradeNum;
            Integer n3 = degradeNum = Integer.valueOf(degradeNum + 1);
            if (degradeNum >= degradeCheckAllowTimes && LOGGER.isWarnEnabled()) {
                LOGGER.warn("the current global transaction has been automatically downgraded");
            }
        } else if (reachNum != 0) {
            reachNum = 0;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.BeforeTransaction;
    }

    static {
        degradeNum = 0;
        reachNum = 0;
        EVENT_BUS = new GuavaEventBus("degradeCheckEventBus", true);
        executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("degradeCheckWorker", 1, true));
        defaultGlobalTransactionTimeout = 0;
    }
}

