/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.hussar.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTimeStampSerializer
extends JsonSerializer<TIMESTAMP> {
    Logger logger = LoggerFactory.getLogger(OracleTimeStampSerializer.class);

    public void serializeWithType(TIMESTAMP timestamp, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)timestamp, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(timestamp, gen, serializers);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    public void serialize(TIMESTAMP timestamp, JsonGenerator gen, SerializerProvider serializers) {
        try {
            String stringValue = timestamp.stringValue();
            gen.writeString(stringValue);
        }
        catch (IOException e) {
            this.logger.error("serialize oracle.sql.TIMESTAMP error : {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

