/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.store;

import io.seata.common.XID;
import io.seata.common.exception.RedisException;
import io.seata.common.exception.StoreException;
import io.seata.common.util.BeanUtils;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.SessionConverter;
import io.seata.server.storage.redis.JedisPooledFactory;
import io.seata.server.store.AbstractTransactionStoreManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public class RedisTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTransactionStoreManager.class);
    private static final String REDIS_SEATA_BRANCHES_PREFIX = "SEATA_BRANCHES_";
    private static final String REDIS_SEATA_BRANCH_PREFIX = "SEATA_BRANCH_";
    private static final String REDIS_SEATA_GLOBAL_PREFIX = "SEATA_GLOBAL_";
    private static final String REDIS_SEATA_STATUS_PREFIX = "SEATA_STATUS_";
    private static volatile RedisTransactionStoreManager instance;
    private static final String OK = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisTransactionStoreManager getInstance() {
        if (instance != null) return instance;
        Class<RedisTransactionStoreManager> clazz = RedisTransactionStoreManager.class;
        synchronized (RedisTransactionStoreManager.class) {
            if (instance != null) return instance;
            instance = new RedisTransactionStoreManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        if (TransactionStoreManager.LogOperation.GLOBAL_ADD.equals((Object)logOperation)) {
            return this.insertGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_UPDATE.equals((Object)logOperation)) {
            return this.updateGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_REMOVE.equals((Object)logOperation)) {
            return this.deleteGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_ADD.equals((Object)logOperation)) {
            return this.insertBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_UPDATE.equals((Object)logOperation)) {
            return this.updateBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_REMOVE.equals((Object)logOperation)) {
            return this.deleteBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        throw new StoreException("Unknown LogOperation:" + logOperation.name());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Date now = new Date();
            branchTransactionDO.setGmtCreate(now);
            branchTransactionDO.setGmtModified(now);
            Pipeline pipelined = jedis.pipelined();
            pipelined.hmset(branchKey, BeanUtils.objectToMap((Object)branchTransactionDO));
            pipelined.rpush(branchListKey, new String[]{branchKey});
            pipelined.sync();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map branchTransactionDOMap = jedis.hgetAll(branchKey);
            String xid = (String)branchTransactionDOMap.get("xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                boolean bl = true;
                return bl;
            }
            String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
            Pipeline pipelined = jedis.pipelined();
            pipelined.lrem(branchListKey, 0L, branchKey);
            pipelined.del(branchKey);
            pipelined.sync();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String previousBranchStatus = jedis.hget(branchKey, "status");
            if (StringUtils.isEmpty((CharSequence)previousBranchStatus)) {
                throw new StoreException("Branch transaction is not exist, update branch transaction failed.");
            }
            HashMap<String, String> map = new HashMap<String, String>(2, 1.0f);
            map.put("status", String.valueOf(branchTransactionDO.getStatus()));
            map.put("gmtModified", String.valueOf(new Date().getTime()));
            jedis.hmset(branchKey, map);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Date now = new Date();
            globalTransactionDO.setGmtCreate(now);
            globalTransactionDO.setGmtModified(now);
            Pipeline pipelined = jedis.pipelined();
            pipelined.hmset(globalKey, BeanUtils.objectToMap((Object)globalTransactionDO));
            pipelined.rpush(this.buildGlobalStatus(globalTransactionDO.getStatus()), new String[]{globalTransactionDO.getXid()});
            pipelined.sync();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map globalTransactionDoMap = jedis.hgetAll(globalKey);
            String xid = (String)globalTransactionDoMap.get("xid");
            if (StringUtils.isEmpty((CharSequence)xid)) {
                LOGGER.warn("Global transaction is not exist,xid = {}.Maybe has been deleted by another tc server", (Object)globalTransactionDO.getXid());
                boolean bl = true;
                return bl;
            }
            Pipeline pipelined = jedis.pipelined();
            pipelined.lrem(this.buildGlobalStatus(globalTransactionDO.getStatus()), 0L, globalTransactionDO.getXid());
            pipelined.del(globalKey);
            pipelined.sync();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        String xid = globalTransactionDO.getXid();
        String globalKey = this.buildGlobalKeyByTransactionId(globalTransactionDO.getTransactionId());
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            jedis.watch(new String[]{globalKey});
            List statusAndGmtModified = jedis.hmget(globalKey, new String[]{"status", "gmtModified"});
            String previousStatus = (String)statusAndGmtModified.get(0);
            if (StringUtils.isEmpty((CharSequence)previousStatus)) {
                jedis.unwatch();
                throw new StoreException("Global transaction is not exist, update global transaction failed.");
            }
            if (previousStatus.equals(String.valueOf(globalTransactionDO.getStatus()))) {
                jedis.unwatch();
                boolean bl = true;
                return bl;
            }
            String previousGmtModified = (String)statusAndGmtModified.get(1);
            Transaction multi = jedis.multi();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("status", String.valueOf(globalTransactionDO.getStatus()));
            map.put("gmtModified", String.valueOf(new Date().getTime()));
            multi.hmset(globalKey, map);
            multi.lrem(this.buildGlobalStatus(Integer.valueOf(previousStatus)), 0L, xid);
            multi.rpush(this.buildGlobalStatus(globalTransactionDO.getStatus()), new String[]{xid});
            List exec = multi.exec();
            String hmset = exec.get(0).toString();
            long lrem = (Long)exec.get(1);
            long rpush = (Long)exec.get(2);
            if (OK.equalsIgnoreCase(hmset) && lrem > 0L && rpush > 0L) {
                boolean bl = true;
                return bl;
            }
            if (OK.equalsIgnoreCase(hmset)) {
                jedis.watch(new String[]{globalKey});
                String xid2 = jedis.hget(globalKey, "xid");
                if (StringUtils.isNotEmpty((CharSequence)xid2)) {
                    HashMap<String, String> mapPrevious = new HashMap<String, String>(2, 1.0f);
                    mapPrevious.put("status", previousStatus);
                    mapPrevious.put("gmtModified", previousGmtModified);
                    Transaction multi2 = jedis.multi();
                    multi2.hmset(globalKey, mapPrevious);
                    multi2.exec();
                }
            }
            if (lrem > 0L) {
                jedis.rpush(this.buildGlobalStatus(Integer.valueOf(previousStatus)), new String[]{xid});
            }
            if (rpush > 0L) {
                jedis.lrem(this.buildGlobalStatus(globalTransactionDO.getStatus()), 0L, xid);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new RedisException((Throwable)ex);
        }
    }

    @Override
    public GlobalSession readSession(String xid, boolean withBranchSessions) {
        String transactionId = String.valueOf(XID.getTransactionId((String)xid));
        String globalKey = this.buildGlobalKeyByTransactionId(transactionId);
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            List<BranchTransactionDO> branchTransactionDOs = null;
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
            return globalSession;
        }
    }

    @Override
    public GlobalSession readSession(String xid) {
        return this.readSession(xid, true);
    }

    public List<GlobalSession> readSession(GlobalStatus[] statuses) {
        ArrayList<String> statusKeys = new ArrayList<String>();
        for (int i = 0; i < statuses.length; ++i) {
            statusKeys.add(this.buildGlobalStatus(statuses[i].getCode()));
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Pipeline pipelined = jedis.pipelined();
            statusKeys.stream().forEach(statusKey -> pipelined.lrange(statusKey, 0L, -1L));
            List list = pipelined.syncAndReturnAll();
            List<Object> xids = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                xids = list.stream().flatMap(ll -> ll.stream()).collect(Collectors.toList());
            }
            ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
            xids.parallelStream().forEach(xid -> {
                GlobalSession globalSession = this.readSession((String)xid, true);
                if (globalSession != null) {
                    globalSessions.add(globalSession);
                }
            });
            ArrayList<GlobalSession> arrayList = globalSessions;
            return arrayList;
        }
    }

    @Override
    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
        if (StringUtils.isNotEmpty((CharSequence)sessionCondition.getXid())) {
            GlobalSession globalSession = this.readSession(sessionCondition.getXid(), true);
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (sessionCondition.getTransactionId() != null) {
            GlobalSession globalSession = this.readSessionByTransactionId(sessionCondition.getTransactionId().toString(), true);
            if (globalSession != null) {
                globalSessions.add(globalSession);
            }
            return globalSessions;
        }
        if (CollectionUtils.isNotEmpty((Object[])sessionCondition.getStatuses())) {
            return this.readSession(sessionCondition.getStatuses());
        }
        if (sessionCondition.getStatus() != null) {
            return this.readSession(new GlobalStatus[]{sessionCondition.getStatus()});
        }
        return null;
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs) {
        GlobalSession globalSession = SessionConverter.convertGlobalSession(globalTransactionDO);
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            for (BranchTransactionDO branchTransactionDO : branchTransactionDOs) {
                globalSession.add(SessionConverter.convertBranchSession(branchTransactionDO));
            }
        }
        return globalSession;
    }

    private GlobalSession readSessionByTransactionId(String transactionId, boolean withBranchSessions) {
        String globalKey = this.buildGlobalKeyByTransactionId(transactionId);
        String xid = null;
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(globalKey);
            if (CollectionUtils.isEmpty((Map)map)) {
                GlobalSession globalSession = null;
                return globalSession;
            }
            GlobalTransactionDO globalTransactionDO = (GlobalTransactionDO)BeanUtils.mapToObject((Map)map, GlobalTransactionDO.class);
            if (globalTransactionDO != null) {
                xid = globalTransactionDO.getXid();
            }
            List<BranchTransactionDO> branchTransactionDOs = new ArrayList<BranchTransactionDO>();
            if (withBranchSessions) {
                branchTransactionDOs = this.readBranchSessionByXid(jedis, xid);
            }
            GlobalSession globalSession = this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
            return globalSession;
        }
    }

    private List<BranchTransactionDO> readBranchSessionByXid(Jedis jedis, String xid) {
        List<Object> branchTransactionDOs = new ArrayList<BranchTransactionDO>();
        String branchListKey = this.buildBranchListKeyByXid(xid);
        List branchKeys = jedis.lrange(branchListKey, 0L, -1L);
        Pipeline pipeline = jedis.pipelined();
        if (CollectionUtils.isNotEmpty((Collection)branchKeys)) {
            branchKeys.stream().forEachOrdered(branchKey -> pipeline.hgetAll(branchKey));
            List branchInfos = pipeline.syncAndReturnAll();
            for (Object branchInfo : branchInfos) {
                if (branchInfo == null) continue;
                Map branchInfoMap = (Map)branchInfo;
                Optional<BranchTransactionDO> branchTransactionDO = Optional.ofNullable((BranchTransactionDO)BeanUtils.mapToObject((Map)branchInfoMap, BranchTransactionDO.class));
                branchTransactionDO.ifPresent(branchTransactionDOs::add);
            }
        }
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            branchTransactionDOs = branchTransactionDOs.stream().sorted(Comparator.comparing(BranchTransactionDO::getGmtCreate)).collect(Collectors.toList());
        }
        return branchTransactionDOs;
    }

    private String buildBranchListKeyByXid(String xid) {
        return REDIS_SEATA_BRANCHES_PREFIX + xid;
    }

    private String buildGlobalKeyByTransactionId(Object transactionId) {
        return REDIS_SEATA_GLOBAL_PREFIX + transactionId;
    }

    private String buildBranchKey(Long branchId) {
        return REDIS_SEATA_BRANCH_PREFIX + branchId;
    }

    private String buildGlobalStatus(Integer status) {
        return REDIS_SEATA_STATUS_PREFIX + status;
    }
}

