/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.lock;

import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.core.exception.TransactionException;
import io.seata.core.lock.Locker;
import io.seata.server.lock.AbstractLockManager;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.storage.redis.lock.RedisLocker;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@LoadLevel(name="redis")
public class RedisLockManager
extends AbstractLockManager
implements Initialize {
    private Locker locker;

    public void init() {
        this.locker = new RedisLocker();
    }

    @Override
    public Locker getLocker(BranchSession branchSession) {
        return this.locker;
    }

    @Override
    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(branchSession.getXid(), Long.valueOf(branchSession.getBranchId()));
        }
        catch (Exception t) {
            LOGGER.error("unLock error, xid {}, branchId:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), t});
            return false;
        }
    }

    @Override
    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        ArrayList<BranchSession> branchSessions = globalSession.getBranchSessions();
        if (CollectionUtils.isEmpty(branchSessions)) {
            return true;
        }
        List branchIds = branchSessions.stream().map(BranchSession::getBranchId).collect(Collectors.toList());
        try {
            return this.getLocker().releaseLock(globalSession.getXid(), branchIds);
        }
        catch (Exception t) {
            LOGGER.error("unLock globalSession error, xid:{} branchIds:{}", new Object[]{globalSession.getXid(), CollectionUtils.toString(branchIds), t});
            return false;
        }
    }
}

