/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.metrics;

import com.google.common.eventbus.Subscribe;
import io.seata.core.event.GlobalTransactionEvent;
import io.seata.core.model.GlobalStatus;
import io.seata.metrics.registry.Registry;
import io.seata.server.metrics.MeterIdConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MetricsSubscriber {
    private final Registry registry;
    private final Map<GlobalStatus, Consumer<GlobalTransactionEvent>> consumers;

    public MetricsSubscriber(Registry registry) {
        this.registry = registry;
        this.consumers = new HashMap<GlobalStatus, Consumer<GlobalTransactionEvent>>();
        this.consumers.put(GlobalStatus.Begin, this::processGlobalStatusBegin);
        this.consumers.put(GlobalStatus.Committed, this::processGlobalStatusCommitted);
        this.consumers.put(GlobalStatus.Rollbacked, this::processGlobalStatusRollbacked);
        this.consumers.put(GlobalStatus.CommitFailed, this::processGlobalStatusCommitFailed);
        this.consumers.put(GlobalStatus.RollbackFailed, this::processGlobalStatusRollbackFailed);
        this.consumers.put(GlobalStatus.TimeoutRollbacked, this::processGlobalStatusTimeoutRollbacked);
        this.consumers.put(GlobalStatus.TimeoutRollbackFailed, this::processGlobalStatusTimeoutRollbackFailed);
    }

    private void processGlobalStatusBegin(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
    }

    private void processGlobalStatusCommitted(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
        this.registry.getCounter(MeterIdConstants.COUNTER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_COMMITTED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processGlobalStatusRollbacked(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
        this.registry.getCounter(MeterIdConstants.COUNTER_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getSummary(MeterIdConstants.SUMMARY_ROLLBACKED.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).increase(1L);
        this.registry.getTimer(MeterIdConstants.TIMER_ROLLBACK.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).record(event.getEndTime() - event.getBeginTime(), TimeUnit.MILLISECONDS);
    }

    private void processGlobalStatusCommitFailed(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    private void processGlobalStatusRollbackFailed(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    private void processGlobalStatusTimeoutRollbacked(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    private void processGlobalStatusTimeoutRollbackFailed(GlobalTransactionEvent event) {
        this.registry.getCounter(MeterIdConstants.COUNTER_ACTIVE.withTag("applicationId", event.getApplicationId()).withTag("group", event.getGroup())).decrease(1L);
    }

    @Subscribe
    public void recordGlobalTransactionEventForMetrics(GlobalTransactionEvent event) {
        if (this.registry != null && this.consumers.containsKey(event.getStatus())) {
            this.consumers.get(event.getStatus()).accept(event);
        }
    }
}

