/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.db.lock;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.StoreException;
import io.seata.common.util.CollectionUtils;
import io.seata.core.lock.AbstractLocker;
import io.seata.core.lock.RowLock;
import io.seata.core.store.LockStore;
import io.seata.server.storage.db.lock.LockStoreDataBaseDAO;
import java.util.List;
import javax.sql.DataSource;

public class DataBaseLocker
extends AbstractLocker {
    private LockStore lockStore;

    public DataBaseLocker() {
    }

    public DataBaseLocker(DataSource logStoreDataSource) {
        this.lockStore = new LockStoreDataBaseDAO(logStoreDataSource);
    }

    public boolean acquireLock(List<RowLock> locks) {
        if (CollectionUtils.isEmpty(locks)) {
            return true;
        }
        try {
            return this.lockStore.acquireLock(this.convertToLockDO(locks));
        }
        catch (StoreException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error("AcquireLock error, locks:{}", (Object)CollectionUtils.toString(locks), (Object)t);
            return false;
        }
    }

    public boolean releaseLock(List<RowLock> locks) {
        if (CollectionUtils.isEmpty(locks)) {
            return true;
        }
        try {
            return this.lockStore.unLock(this.convertToLockDO(locks));
        }
        catch (StoreException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error("unLock error, locks:{}", (Object)CollectionUtils.toString(locks), (Object)t);
            return false;
        }
    }

    public boolean releaseLock(String xid, Long branchId) {
        try {
            return this.lockStore.unLock(xid, branchId);
        }
        catch (StoreException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error("unLock by branchId error, xid {}, branchId:{}", new Object[]{xid, branchId, t});
            return false;
        }
    }

    public boolean releaseLock(String xid, List<Long> branchIds) {
        if (CollectionUtils.isEmpty(branchIds)) {
            return true;
        }
        try {
            return this.lockStore.unLock(xid, branchIds);
        }
        catch (StoreException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error("unLock by branchIds error, xid {}, branchIds:{}", new Object[]{xid, CollectionUtils.toString(branchIds), t});
            return false;
        }
    }

    public boolean isLockable(List<RowLock> locks) {
        if (CollectionUtils.isEmpty(locks)) {
            return true;
        }
        try {
            return this.lockStore.isLockable(this.convertToLockDO(locks));
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception t) {
            LOGGER.error("isLockable error, locks:{}", (Object)CollectionUtils.toString(locks), (Object)t);
            return false;
        }
    }

    public void setLockStore(LockStore lockStore) {
        this.lockStore = lockStore;
    }
}

