/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.evaluation.Evaluator;
import io.seata.saga.engine.evaluation.EvaluatorFactory;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.utils.ExceptionUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.ChoiceState;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.impl.ChoiceStateImpl;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ChoiceStateHandler
implements StateHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        ChoiceStateImpl choiceState = (ChoiceStateImpl)instruction.getState(context);
        LinkedHashMap<Evaluator, String> choiceEvaluators = choiceState.getChoiceEvaluators();
        if (choiceEvaluators == null) {
            ChoiceStateImpl choiceStateImpl = choiceState;
            synchronized (choiceStateImpl) {
                choiceEvaluators = choiceState.getChoiceEvaluators();
                if (choiceEvaluators == null) {
                    List choices = choiceState.getChoices();
                    if (choices == null) {
                        choiceEvaluators = new LinkedHashMap<Evaluator, String>(0);
                    } else {
                        choiceEvaluators = new LinkedHashMap(choices.size());
                        Iterator iterator = choices.iterator();
                        while (iterator.hasNext()) {
                            ChoiceState.Choice choice = (ChoiceState.Choice)iterator.next();
                            Evaluator evaluator = this.getEvaluatorFactory(context).createEvaluator(choice.getExpression());
                            choiceEvaluators.put(evaluator, choice.getNext());
                        }
                    }
                    choiceState.setChoiceEvaluators(choiceEvaluators);
                }
            }
        }
        for (Map.Entry entry : choiceEvaluators.entrySet()) {
            Evaluator evaluator = (Evaluator)entry.getKey();
            if (!evaluator.evaluate(context.getVariables())) continue;
            context.setVariable("_current_choice_", entry.getValue());
            return;
        }
        if (StringUtils.isEmpty((Object)choiceState.getDefault())) {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            EngineExecutionException exception = ExceptionUtils.createEngineExecutionException(FrameworkErrorCode.StateMachineNoChoiceMatched, "No choice matched, maybe it is a bug. Choice state name: " + choiceState.getName(), stateMachineInstance, null);
            EngineUtils.failStateMachine(context, (Exception)((Object)exception));
            throw exception;
        }
        context.setVariable("_current_choice_", (Object)choiceState.getDefault());
    }

    public EvaluatorFactory getEvaluatorFactory(ProcessContext context) {
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        return stateMachineConfig.getEvaluatorFactoryManager().getEvaluatorFactory("Default");
    }
}

