/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.handlers.ScriptTaskStateHandler;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineUtils.class);

    public static String generateParentId(StateInstance stateInstance) {
        return stateInstance.getMachineInstanceId() + ":" + stateInstance.getId();
    }

    public static String getOriginStateName(StateInstance stateInstance) {
        int end;
        String stateName = stateInstance.getName();
        if (StringUtils.isNotBlank((String)stateName) && (end = stateName.lastIndexOf("-loop-")) > -1) {
            return stateName.substring(0, end);
        }
        return stateName;
    }

    public static void endStateMachine(ProcessContext context) {
        AsyncCallback callback;
        if (context.hasVariable("_is_loop_state_")) {
            if (context.hasVariable("loopSemaphore")) {
                Semaphore semaphore = (Semaphore)context.getVariable("loopSemaphore");
                semaphore.release();
            }
            return;
        }
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        stateMachineInstance.setGmtEnd(new Date());
        Exception exp = (Exception)context.getVariable("currentException");
        if (exp != null) {
            stateMachineInstance.setException(exp);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exception Occurred: " + exp);
            }
        }
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        stateMachineConfig.getStatusDecisionStrategy().decideOnEndState(context, stateMachineInstance, exp);
        stateMachineInstance.getEndParams().putAll((Map)context.getVariable("context"));
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        instruction.setEnd(true);
        stateMachineInstance.setRunning(false);
        stateMachineInstance.setGmtEnd(new Date());
        if (stateMachineInstance.getStateMachine().isPersist() && stateMachineConfig.getStateLogStore() != null) {
            stateMachineConfig.getStateLogStore().recordStateMachineFinished(stateMachineInstance, context);
        }
        if ((callback = (AsyncCallback)context.getVariable("_async_callback_")) != null) {
            if (exp != null) {
                callback.onError(context, stateMachineInstance, exp);
            } else {
                callback.onFinished(context, stateMachineInstance);
            }
        }
    }

    public static void failStateMachine(ProcessContext context, Exception exp) {
        AsyncCallback callback;
        if (context.hasVariable("_is_loop_state_")) {
            return;
        }
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        stateMachineConfig.getStatusDecisionStrategy().decideOnTaskStateFail(context, stateMachineInstance, exp);
        stateMachineInstance.getEndParams().putAll((Map)context.getVariable("context"));
        StateInstruction instruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        instruction.setEnd(true);
        stateMachineInstance.setRunning(false);
        stateMachineInstance.setGmtEnd(new Date());
        stateMachineInstance.setException(exp);
        if (stateMachineInstance.getStateMachine().isPersist() && stateMachineConfig.getStateLogStore() != null) {
            stateMachineConfig.getStateLogStore().recordStateMachineFinished(stateMachineInstance, context);
        }
        if ((callback = (AsyncCallback)context.getVariable("_async_callback_")) != null) {
            callback.onError(context, stateMachineInstance, exp);
        }
    }

    public static boolean isTimeout(Date gmtUpdated, int timeoutMillis) {
        if (gmtUpdated == null || timeoutMillis < 0) {
            return false;
        }
        return System.currentTimeMillis() - gmtUpdated.getTime() > (long)timeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(ProcessContext context, AbstractTaskState state, Throwable e) {
        List catches = state.getCatches();
        if (CollectionUtils.isNotEmpty((Collection)catches)) {
            for (TaskState.ExceptionMatch exceptionMatch : catches) {
                List exceptions = exceptionMatch.getExceptions();
                ArrayList exceptionClasses = exceptionMatch.getExceptionClasses();
                if (!CollectionUtils.isNotEmpty((Collection)exceptions)) continue;
                if (exceptionClasses == null) {
                    TaskState.ExceptionMatch exceptionMatch2 = exceptionMatch;
                    synchronized (exceptionMatch2) {
                        exceptionClasses = exceptionMatch.getExceptionClasses();
                        if (exceptionClasses == null) {
                            exceptionClasses = new ArrayList(exceptions.size());
                            for (String expStr : exceptions) {
                                Class<?> expClass = null;
                                try {
                                    expClass = ScriptTaskStateHandler.class.getClassLoader().loadClass(expStr);
                                }
                                catch (Exception e1) {
                                    LOGGER.warn("Cannot Load Exception Class by getClass().getClassLoader()", (Throwable)e1);
                                    try {
                                        expClass = Thread.currentThread().getContextClassLoader().loadClass(expStr);
                                    }
                                    catch (Exception e2) {
                                        LOGGER.warn("Cannot Load Exception Class by Thread.currentThread().getContextClassLoader()", (Throwable)e2);
                                    }
                                }
                                if (expClass == null) continue;
                                exceptionClasses.add(expClass);
                            }
                            exceptionMatch.setExceptionClasses(exceptionClasses);
                        }
                    }
                }
                for (Class clazz : exceptionClasses) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    ((HierarchicalProcessContext)context).setVariableLocally("_current_exception_route_", (Object)exceptionMatch.getNext());
                    return;
                }
            }
        }
        LOGGER.error("Task execution failed and no catches configured");
        ((HierarchicalProcessContext)context).setVariableLocally("_is_exception_not_catch_", (Object)true);
    }
}

