/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.sqlserver;

import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.struct.TableMeta;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

@LoadLevel(name="sqlserver", scope=Scope.PROTOTYPE)
public class SqlServerUpdateExecutor<T, S extends Statement>
extends UpdateExecutor<T, S> {
    public SqlServerUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected String buildBeforeImageSQL(TableMeta tableMeta, ArrayList<List<Object>> paramAppenderList) {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        StringBuilder prefix = new StringBuilder("SELECT ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL()).append(" WITH(UPDLOCK) ");
        String whereCondition = this.buildWhereCondition((WhereRecognizer)recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix.toString(), suffix.toString());
        List<String> needUpdateColumns = this.getNeedColumns(tableMeta.getTableName(), this.sqlRecognizer.getTableAlias(), recognizer.getUpdateColumnsUnEscape());
        for (String needUpdateColumn : needUpdateColumns) {
            selectSQLJoin.add(needUpdateColumn);
        }
        return selectSQLJoin.toString();
    }
}

