/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.sqlserver;

import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.SelectForUpdateExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLSelectRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlServerSelectForUpdateExecutor<T, S extends Statement>
extends SelectForUpdateExecutor<T, S> {
    public SqlServerSelectForUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected String buildSelectSQL(ArrayList<List<Object>> paramAppenderList) {
        SQLSelectRecognizer recognizer = (SQLSelectRecognizer)this.sqlRecognizer;
        StringBuilder selectSQLAppender = new StringBuilder("SELECT ");
        selectSQLAppender.append(this.getColumnNamesInSQL(this.getTableMeta().getEscapePkNameList(this.getDbType())));
        selectSQLAppender.append(" FROM ").append(this.getFromTableInSQL()).append(" WITH(UPDLOCK) ");
        String whereCondition = this.buildWhereCondition((WhereRecognizer)recognizer, paramAppenderList);
        String orderByCondition = this.buildOrderCondition((WhereRecognizer)recognizer, paramAppenderList);
        String limitCondition = this.buildLimitCondition((WhereRecognizer)recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            selectSQLAppender.append(" WHERE ").append(whereCondition);
        }
        if (StringUtils.isNotBlank((String)orderByCondition)) {
            selectSQLAppender.append(" ").append(orderByCondition);
        }
        if (StringUtils.isNotBlank((String)limitCondition)) {
            selectSQLAppender.append(" ").append(limitCondition);
        }
        return selectSQLAppender.toString();
    }
}

